/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.panels;

import com.valeras.color_combine.model.ColorMixing;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.ui.swing.AbstractComponentBorderFactory;
import com.valeras.colorwheel_harmony.ui.swing.components.JxImageView;
import com.valeras.colorwheel_harmony.ui.swing.components.JxSplitColor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GradientPanel
extends JPanel {
    private static final String STR_PREVIEW_LABEL = "panel.gradient.label.preview";
    private static final String STR_COLORS_LABEL = "panel.gradient.label.colors";
    private static final String STR_TINT_LABEL = "panel.gradient.label.tint";
    private static final String STR_SATURATION_LABEL = "panel.gradient.label.saturation";
    private static final String STR_DIRECTION_LABEL = "panel.gradient.label.direction";
    private static final String STR_RESOLUTION_LABEL = "panel.gradient.label.resolution";
    private static final String STR_WIDTH_LABEL = "panel.gradient.label.width";
    private static final String STR_HEIGHT_LABEL = "panel.gradient.label.height";
    private static final String STR_BUTTON_SAVE = "panel.gradient.button.save";
    private static final String STR_VARIATION_TINT = "panel.gradient.variation.tint";
    private static final String STR_VARIATION_SHADE = "panel.gradient.variation.shade";
    private static final String STR_VARIATION_BRIGHTER = "panel.gradient.variation.brighter";
    private static final String STR_VARIATION_DARKER = "panel.gradient.variation.darker";
    private static final String STR_VARIATION_WHITE = "panel.gradient.variation.white";
    private static final String STR_VARIATION_BLACK = "panel.gradient.variation.black";
    private static final String STR_VARIATION_COLOR2 = "panel.gradient.variation.color2";
    private static final String STR_DIRECTION_UP = "panel.gradient.direction.up";
    private static final String STR_DIRECTION_DOWN = "panel.gradient.direction.down";
    private static final String STR_DIRECTION_LEFT = "panel.gradient.direction.left";
    private static final String STR_DIRECTION_RIGHT = "panel.gradient.direction.right";
    private static final String STR_RESOLUTION_FORMAT = "panel.gradient.resolution.format";
    private static final Insets DEFAULT_INSETS = new Insets(2, 2, 3, 5);
    private static final Insets DEFAULT_GROUP_INSETS = new Insets(7, 2, 3, 5);
    private static final float TINT_AMOUNT = 0.25f;
    private static final float BRIGHTNESS_AMOUNT = 0.5f;
    private final JxImageView imgView;
    private final JPanel contentPanel;
    private final Color baseColor;
    private final Color color2;
    private Color secondColor;
    private BufferedImage image;
    private final AbstractAction writeImageAction;
    private final JxSplitColor lblColors;
    private final JComboBox cmbTint;
    private final JComboBox cmbDirection;
    private final JComboBox cmbResolution;
    private final JCheckBox chbSaturation;
    private final JTextField txtWidth;
    private final JTextField txtHeight;
    private final JButton btnSave;
    private final ComboBoxModel colorVariationModel;
    private final ComboBoxModel resolutionModel;
    private final ComboBoxModel directionModel;
    private final ResolutionChangeListener imageSizeListener;

    public GradientPanel(Color color, Color color2, AbstractAction writeImage) {
        super(new BorderLayout());
        Dimension l_panelSize = new Dimension(240, 240);
        this.image = null;
        this.baseColor = color;
        this.color2 = color2;
        this.writeImageAction = writeImage;
        this.colorVariationModel = this.createColorVariationModel();
        this.colorVariationModel.setSelectedItem(this.colorVariationModel.getElementAt(0));
        this.resolutionModel = this.createImageResolutionModel();
        this.resolutionModel.setSelectedItem(this.resolutionModel.getElementAt(0));
        this.directionModel = this.createGradientDirectionModel();
        this.directionModel.setSelectedItem(this.directionModel.getElementAt(0));
        this.imageSizeListener = new ResolutionChangeListener();
        this.contentPanel = new JPanel(new GridBagLayout());
        this.lblColors = new JxSplitColor();
        this.lblColors.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.lblColors.setForeground(this.baseColor);
        this.cmbTint = new JComboBox(this.colorVariationModel);
        this.cmbTint.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GradientPanel.this.updateColor();
                    GradientPanel.this.updateImage();
                }
            }
        });
        this.chbSaturation = new JCheckBox(StringTable.get(STR_SATURATION_LABEL));
        this.chbSaturation.setSelected(true);
        this.cmbDirection = new JComboBox(this.directionModel);
        this.cmbDirection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GradientPanel.this.updateImage();
                }
            }
        });
        this.cmbResolution = new JComboBox(this.resolutionModel);
        this.cmbResolution.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GradientPanel.this.updateResolution();
                }
            }
        });
        this.txtWidth = new JTextField(6);
        this.txtWidth.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                GradientPanel.this.txtWidth.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.txtHeight = new JTextField(6);
        this.txtHeight.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                GradientPanel.this.txtHeight.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.btnSave = new JButton(StringTable.get(STR_BUTTON_SAVE));
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GradientPanel.this.writeImageAction.actionPerformed(null);
            }
        });
        this.imgView = new JxImageView();
        this.imgView.setBorder(this.createPaneBorder(StringTable.get(STR_PREVIEW_LABEL)));
        this.imgView.setPreferredSize(l_panelSize);
        this.contentPanel.add((Component)this.lblColors, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 1, DEFAULT_INSETS, 0, 0));
        this.contentPanel.add((Component)new JLabel(StringTable.get(STR_TINT_LABEL)), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, DEFAULT_GROUP_INSETS, 0, 0));
        this.contentPanel.add((Component)this.cmbTint, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, DEFAULT_INSETS, 0, 0));
        this.contentPanel.add((Component)new JLabel(StringTable.get(STR_DIRECTION_LABEL)), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, DEFAULT_GROUP_INSETS, 0, 0));
        this.contentPanel.add((Component)this.cmbDirection, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, DEFAULT_GROUP_INSETS, 0, 0));
        this.contentPanel.add((Component)new JLabel(StringTable.get(STR_RESOLUTION_LABEL)), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, DEFAULT_GROUP_INSETS, 0, 0));
        this.contentPanel.add((Component)this.cmbResolution, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, DEFAULT_GROUP_INSETS, 0, 0));
        this.contentPanel.add((Component)new JLabel(StringTable.get(STR_WIDTH_LABEL)), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, DEFAULT_INSETS, 0, 0));
        this.contentPanel.add((Component)this.txtWidth, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, DEFAULT_INSETS, 0, 0));
        this.contentPanel.add((Component)new JLabel(StringTable.get(STR_HEIGHT_LABEL)), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, DEFAULT_INSETS, 0, 0));
        this.contentPanel.add((Component)this.txtHeight, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, DEFAULT_INSETS, 0, 0));
        this.contentPanel.add((Component)this.btnSave, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 14, 0, DEFAULT_GROUP_INSETS, 0, 0));
        this.contentPanel.add((Component)this.imgView, new GridBagConstraints(3, 0, 1, 7, 0.0, 0.0, 17, 1, DEFAULT_INSETS, 0, 0));
        this.contentPanel.add((Component)new JSeparator(), new GridBagConstraints(0, 7, 4, 1, 0.0, 0.0, 17, 2, DEFAULT_GROUP_INSETS, 0, 0));
        this.add((Component)this.contentPanel, "Center");
        this.updateColor();
        this.updateResolution();
        this.updateImage();
        this.txtWidth.getDocument().addDocumentListener(this.imageSizeListener);
        this.txtHeight.getDocument().addDocumentListener(this.imageSizeListener);
    }

    public BufferedImage getGradientImage() {
        return this.image;
    }

    public String getGradientName() {
        return "gradient";
    }

    private void updateImage() {
        this.image = this.produceGradient();
        this.imgView.setImage(this.image);
    }

    private BufferedImage produceGradient() {
        Point2D.Float l_ptEnd;
        Point2D.Float l_ptStart;
        int l_height;
        int l_width;
        Color[] l_colors = new Color[2];
        float[] l_fractions = new float[]{0.0f, 1.0f};
        try {
            l_width = Integer.parseInt(this.txtWidth.getText());
            l_height = Integer.parseInt(this.txtHeight.getText());
        }
        catch (NumberFormatException ex) {
            return null;
        }
        if (l_width <= 0 || l_height <= 0) {
            return null;
        }
        l_colors[0] = this.baseColor;
        l_colors[1] = this.secondColor;
        switch (((GradientDirection)this.directionModel.getSelectedItem()).getDirection()) {
            case 1: {
                l_ptStart = new Point2D.Float(0.0f, l_height - 1);
                l_ptEnd = new Point2D.Float(0.0f, 0.0f);
                if (l_height != 1) break;
                return null;
            }
            case 3: {
                l_ptStart = new Point2D.Float(0.0f, 0.0f);
                l_ptEnd = new Point2D.Float(0.0f, l_height - 1);
                if (l_height != 1) break;
                return null;
            }
            case 2: {
                l_ptStart = new Point2D.Float(l_width - 1, 0.0f);
                l_ptEnd = new Point2D.Float(0.0f, 0.0f);
                if (l_width != 1) break;
                return null;
            }
            case 4: {
                l_ptStart = new Point2D.Float(0.0f, 0.0f);
                l_ptEnd = new Point2D.Float(l_width - 1, 0.0f);
                if (l_width != 1) break;
                return null;
            }
            default: {
                l_ptStart = new Point2D.Float(0.0f, 0.0f);
                l_ptEnd = new Point2D.Float(0.0f, l_height - 1);
            }
        }
        BufferedImage l_image = new BufferedImage(l_width, l_height, 1);
        Graphics2D l_gr = l_image.createGraphics();
        LinearGradientPaint l_paint = new LinearGradientPaint(l_ptStart, l_ptEnd, l_fractions, l_colors);
        l_gr.setPaint(l_paint);
        l_gr.fillRect(0, 0, l_width, l_height);
        l_gr.dispose();
        return l_image;
    }

    private void updateColor() {
        ColorVariation l_variation = (ColorVariation)this.colorVariationModel.getSelectedItem();
        this.secondColor = l_variation.apply(this.baseColor);
        this.lblColors.setBackground(this.secondColor);
    }

    private void updateResolution() {
        Dimension l_size = ((ImageResolution)this.resolutionModel.getSelectedItem()).getSize();
        this.txtWidth.setText(Integer.toString(l_size.width));
        this.txtHeight.setText(Integer.toString(l_size.height));
    }

    private Border createPaneBorder(String title) {
        return AbstractComponentBorderFactory.createComponentBorder(null, false);
    }

    private ComboBoxModel createImageResolutionModel() {
        ImageResolution[] l_items = new ImageResolution[]{new ImageResolution(new Dimension(8, 8)), new ImageResolution(new Dimension(16, 16)), new ImageResolution(new Dimension(32, 32)), new ImageResolution(new Dimension(64, 64)), new ImageResolution(new Dimension(128, 128)), new ImageResolution(new Dimension(256, 256)), new ImageResolution(new Dimension(512, 512))};
        return new DefaultComboBoxModel<ImageResolution>(l_items);
    }

    private ComboBoxModel createGradientDirectionModel() {
        GradientDirection[] l_items = new GradientDirection[]{new GradientDirection(StringTable.get(STR_DIRECTION_UP), 1), new GradientDirection(StringTable.get(STR_DIRECTION_DOWN), 3), new GradientDirection(StringTable.get(STR_DIRECTION_LEFT), 2), new GradientDirection(StringTable.get(STR_DIRECTION_RIGHT), 4)};
        return new DefaultComboBoxModel<GradientDirection>(l_items);
    }

    private ComboBoxModel createColorVariationModel() {
        ColorVariation[] l_variators = new ColorVariation[]{new ColorVariation(StringTable.get(STR_VARIATION_BRIGHTER), new ColorVariationMethod(){

            @Override
            public Color apply(Color color) {
                return ColorMixing.adjust((Color)color, (float)0.0f, (float)0.0f, (float)0.5f);
            }
        }), new ColorVariation(StringTable.get(STR_VARIATION_DARKER), new ColorVariationMethod(){

            @Override
            public Color apply(Color color) {
                return ColorMixing.adjust((Color)color, (float)0.0f, (float)0.0f, (float)-0.5f);
            }
        }), new ColorVariation(StringTable.get(STR_VARIATION_TINT), new ColorVariationMethod(){

            @Override
            public Color apply(Color color) {
                return ColorMixing.tint((Color)color, (float)0.25f);
            }
        }), new ColorVariation(StringTable.get(STR_VARIATION_SHADE), new ColorVariationMethod(){

            @Override
            public Color apply(Color color) {
                return ColorMixing.shade((Color)color, (float)0.25f);
            }
        }), new ColorVariation(StringTable.get(STR_VARIATION_WHITE), new ColorVariationMethod(){

            @Override
            public Color apply(Color color) {
                return Color.white;
            }
        }), new ColorVariation(StringTable.get(STR_VARIATION_BLACK), new ColorVariationMethod(){

            @Override
            public Color apply(Color color) {
                return Color.black;
            }
        }), new ColorVariation(StringTable.get(STR_VARIATION_COLOR2), new ColorVariationMethod(){

            @Override
            public Color apply(Color color) {
                return GradientPanel.this.color2 != null ? GradientPanel.this.color2 : Color.white;
            }
        })};
        return new DefaultComboBoxModel<ColorVariation>(l_variators);
    }

    private class ResolutionChangeListener
    implements DocumentListener {
        private ResolutionChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            GradientPanel.this.updateImage();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            GradientPanel.this.updateImage();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            GradientPanel.this.updateImage();
        }
    }

    private static interface ColorVariationMethod {
        public Color apply(Color var1);
    }

    private static class ColorVariation {
        private final String name;
        private final ColorVariationMethod method;

        public ColorVariation(String name, ColorVariationMethod method) {
            this.name = name;
            this.method = method;
        }

        public Color apply(Color source) {
            return this.method.apply(source);
        }

        public String toString() {
            return this.name;
        }
    }

    private static class GradientDirection {
        private final String text;
        private final int direction;

        public GradientDirection(String text, int direction) {
            this.text = text;
            this.direction = direction;
        }

        public int getDirection() {
            return this.direction;
        }

        public String toString() {
            return this.text;
        }
    }

    private static class ImageResolution {
        private final Dimension size;

        public ImageResolution(Dimension size) {
            this.size = size;
        }

        public Dimension getSize() {
            return this.size;
        }

        public String toString() {
            return MessageFormat.format(StringTable.get(GradientPanel.STR_RESOLUTION_FORMAT), this.size.width, this.size.height);
        }
    }
}

