/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.panels;

import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.model.ColorDetails;
import com.valeras.colorwheel_harmony.ui.model.ColorPickerModel;
import com.valeras.colorwheel_harmony.ui.swing.components.JxSplitColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class ColorComponentEditPanel
extends JPanel {
    private static final String STR_SAMPLE = "panel.color_component_edit.color_card.label";
    private static final String STR_COLOR_NAME = "panel.color_component_edit.border.color_name";
    private static final String STR_CMYK_PROFILE = "panel.color_component_edit.cmyk_profile";
    private static final String STR_RGB_EDITOR = "panel.color_component_edit.border_rgb";
    private static final String STR_HSB_EDITOR = "panel.color_component_edit.border_hsb";
    private static final String STR_LAB_EDITOR = "panel.color_component_edit.border_lab";
    private static final String STR_CMYK_EDITOR = "panel.color_component_edit.border_cmyk";
    private final Insets insets = new Insets(2, 5, 7, 5);
    private final Insets labelInsets = new Insets(2, 5, 0, 5);
    private final Insets componentInsets = new Insets(0, 0, 2, 2);
    private final JxSplitColor colorCard;
    private final JTextField colorName;
    private final JLabel cmykProfile;
    private final HashMap<Integer, ColorModelEditor> editors;
    private final JTextField hexCode;
    private final ColorComponentFocusListener defaultTextComponentFocusListener;
    private final HexCodeDocumentListener hexCodeDocumentListener;
    private final ColorPickerModel model;

    public ColorComponentEditPanel(ColorPickerModel colorPickerModel) {
        ArrayList<Component> l_editables = new ArrayList<Component>();
        this.setLayout(new GridBagLayout());
        this.model = colorPickerModel;
        this.editors = new HashMap();
        this.defaultTextComponentFocusListener = new ColorComponentFocusListener();
        this.hexCode = new JTextField(6);
        this.hexCodeDocumentListener = new HexCodeDocumentListener();
        this.hexCode.addFocusListener(this.defaultTextComponentFocusListener);
        this.hexCode.getDocument().addDocumentListener(this.hexCodeDocumentListener);
        ColorModelEditor l_rgbEditor = new ColorModelEditor(this.model.getModel(5));
        ColorModelEditor l_hsbEditor = new ColorModelEditor(this.model.getModel(7));
        ColorModelEditor l_labEditor = this.model.isLabSupported() ? new ColorModelEditor(this.model.getModel(1)) : null;
        ColorModelEditor l_cmykEditor = this.model.isCMYKSupported() ? new ColorModelEditor(this.model.getModel(9)) : null;
        this.editors.put(7, l_hsbEditor);
        l_editables.addAll(l_hsbEditor.listComponents());
        this.editors.put(5, l_rgbEditor);
        l_editables.addAll(l_rgbEditor.listComponents());
        l_editables.add(this.hexCode);
        if (l_labEditor != null) {
            this.editors.put(1, l_labEditor);
            l_editables.addAll(l_labEditor.listComponents());
        }
        if (l_cmykEditor != null) {
            this.editors.put(9, l_cmykEditor);
            l_editables.addAll(l_cmykEditor.listComponents());
        }
        this.colorName = new JTextField(24);
        this.colorName.setEditable(false);
        this.cmykProfile = colorPickerModel.isCMYKSupported() ? new JLabel(MessageFormat.format(StringTable.get(STR_CMYK_PROFILE), colorPickerModel.getCMYKProfileName())) : null;
        this.colorCard = new JxSplitColor(2);
        Color l_color = this.model.getColor();
        this.colorCard.setBackground(l_color);
        this.colorCard.setForeground(l_color);
        JPanel l_editorPanel = new JPanel();
        l_editorPanel.setLayout(new GridBagLayout());
        this.layoutEditor(l_editorPanel, l_hsbEditor, 0, 0, this.componentInsets);
        l_editorPanel.add(Box.createVerticalStrut(8), new GridBagConstraints(0, l_rgbEditor.getNumComponents(), 1, 1, 0.0, 0.0, 17, 2, this.insets, 0, 0));
        this.layoutEditor(l_editorPanel, l_rgbEditor, 0, l_rgbEditor.getNumComponents() + 1, this.componentInsets);
        l_editorPanel.add((Component)new JLabel("#"), new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, this.componentInsets, 0, 0));
        l_editorPanel.add((Component)this.hexCode, new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 17, 2, this.componentInsets, 0, 0));
        if (l_labEditor != null) {
            this.layoutEditor(l_editorPanel, l_labEditor, 4, 0, this.componentInsets);
        }
        if (l_cmykEditor != null) {
            this.layoutEditor(l_editorPanel, l_cmykEditor, 4, l_labEditor != null ? l_labEditor.getNumComponents() + 1 : 0, this.componentInsets);
        }
        if (l_labEditor != null || l_cmykEditor != null) {
            l_editorPanel.add(Box.createHorizontalStrut(16), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, this.insets, 0, 0));
        }
        CustomOrderFocusTraversalPolicy l_focusTraversalPolicy = new CustomOrderFocusTraversalPolicy(l_editorPanel, l_editables);
        l_editorPanel.setFocusTraversalPolicyProvider(true);
        l_editorPanel.setFocusTraversalPolicy(l_focusTraversalPolicy);
        this.add((Component)new JLabel(StringTable.get(STR_COLOR_NAME)), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, this.labelInsets, 0, 0));
        this.add((Component)this.colorName, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 2, this.insets, 0, 0));
        this.add((Component)this.colorCard, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 12, 1, this.insets, 0, 0));
        this.add((Component)l_editorPanel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 0, this.insets, 0, 0));
        if (this.cmykProfile != null) {
            // empty if block
        }
        this.updateEditors();
        this.model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorComponentEditPanel.this.updateEditors();
            }
        });
    }

    private void layoutEditor(JComponent panel, ColorModelEditor editor, int x, int y, Insets insets) {
        for (int i = 0; i < editor.getNumComponents(); ++i) {
            ColorModelEditor.ColorComponentField l_field = editor.getField(i);
            ColorPickerModel.ComponentParams l_params = l_field.getParams();
            String l_measure = l_params.getMeasure();
            JTextComponent l_component = l_field.getComponent();
            panel.add((Component)new JLabel(l_params.getLabel() + ":"), new GridBagConstraints(x, y + i, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
            panel.add((Component)l_component, new GridBagConstraints(x + 1, y + i, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0));
            if (l_measure == null) continue;
            panel.add((Component)new JLabel(l_measure), new GridBagConstraints(x + 2, y + i, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        }
    }

    public ColorPickerModel getModel() {
        return this.model;
    }

    private void updateEditors() {
        String l_name;
        Collection<ColorModelEditor> l_editors = this.editors.values();
        int l_rgb = this.model.getRGB();
        Color l_color = new Color(l_rgb);
        if (l_color == null) {
            return;
        }
        ColorDetails l_details = ColorDetails.getDetails(l_color);
        String string = l_name = l_details != null ? l_details.getDisplayName() : null;
        this.colorName.setText(l_name != null ? l_name : (l_details != null ? l_details.getCode() : "n/a"));
        this.colorCard.setForeground(l_color);
        boolean l_ignoreUpdates = ColorComponentDocumentListener.isIgnoreUpdates();
        ColorComponentDocumentListener.setIgnoreUpdates(true);
        for (ColorModelEditor e : l_editors) {
            if (e.isUpdating()) continue;
            e.updateFields();
        }
        ColorComponentDocumentListener.setIgnoreUpdates(l_ignoreUpdates);
        if (!this.hexCodeDocumentListener.isUpdating()) {
            l_ignoreUpdates = this.hexCodeDocumentListener.isIgnoreUpdates();
            this.hexCodeDocumentListener.setIgnoreUpdates(true);
            this.hexCode.setText(ColorComponentEditPanel.formatRGB(l_rgb));
            this.hexCodeDocumentListener.setIgnoreUpdates(l_ignoreUpdates);
        }
    }

    protected static String formatRGB(int rgb) {
        String l_text = "";
        String l_rgb = Integer.toHexString(rgb & 0xFFFFFF);
        int l_count = l_rgb.length();
        if (l_count < 6) {
            l_count = 6 - l_count;
            for (int i = 0; i < l_count; ++i) {
                l_text = l_text + "0";
            }
        }
        l_text = l_text + l_rgb;
        return l_text.toUpperCase();
    }

    private static class CustomOrderFocusTraversalPolicy
    extends ContainerOrderFocusTraversalPolicy {
        private final Container container;
        private final List<Component> components;

        public CustomOrderFocusTraversalPolicy(Container container, List<Component> components) {
            this.container = container;
            this.components = Collections.unmodifiableList(components);
        }

        @Override
        protected boolean accept(Component aComponent) {
            return this.components.contains(aComponent);
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            int l_index = this.components.indexOf(aComponent) + 1;
            return l_index < this.components.size() ? this.components.get(l_index) : null;
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            int l_index = this.components.indexOf(aComponent) - 1;
            return l_index >= 0 ? this.components.get(l_index) : null;
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            return this.components.get(0);
        }

        @Override
        public boolean getImplicitDownCycleTraversal() {
            return super.getImplicitDownCycleTraversal();
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            return this.components.get(this.components.size() - 1);
        }

        @Override
        public void setImplicitDownCycleTraversal(boolean implicitDownCycleTraversal) {
            super.setImplicitDownCycleTraversal(implicitDownCycleTraversal);
        }
    }

    private static class ColorComponentMouseWheelListener
    implements MouseWheelListener {
        private final ColorModelEditor editor;
        private final int index;

        public ColorComponentMouseWheelListener(ColorModelEditor editor, int index) {
            this.editor = editor;
            this.index = index;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            String l_text;
            ColorPickerModel.ColorModel l_model = this.editor.getModel();
            ColorPickerModel.ComponentParams l_params = l_model.getComponentParams(this.index);
            NumberFormat l_format = l_params.getFormat();
            int l_steps = e.getWheelRotation();
            JTextComponent l_component = (JTextComponent)e.getComponent();
            Document l_document = l_component.getDocument();
            try {
                l_text = l_document.getText(0, l_document.getLength()).trim();
            }
            catch (BadLocationException ex) {
                Logger.getLogger(ColorComponentEditPanel.class.getName()).log(Level.WARNING, null, ex);
                return;
            }
            if (!l_text.isEmpty()) {
                double l_value;
                try {
                    l_value = l_format.parse(l_text).doubleValue();
                }
                catch (ParseException ex) {
                    Logger.getLogger(ColorPickerModel.class.getName()).log(Level.WARNING, null, ex);
                    return;
                }
                if ((l_value -= (double)l_steps * l_params.getStep()) > l_params.getMaxValue() || l_value < l_params.getMinValue()) {
                    return;
                }
                l_text = l_format.format(l_value);
                l_component.setText(l_text);
            }
        }
    }

    private static class ColorComponentFocusListener
    implements FocusListener {
        private ColorComponentFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            JTextComponent l_component = (JTextComponent)e.getComponent();
            l_component.selectAll();
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    private class HexCodeDocumentListener
    implements DocumentListener {
        private boolean updating = false;
        private boolean ignoreUpdates;

        public void setIgnoreUpdates(boolean flag) {
            this.ignoreUpdates = flag;
        }

        public boolean isIgnoreUpdates() {
            return this.ignoreUpdates;
        }

        public boolean isUpdating() {
            return this.updating;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (!this.isIgnoreUpdates()) {
                this.updateEditor(e);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (!this.isIgnoreUpdates()) {
                this.updateEditor(e);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        private void updateEditor(DocumentEvent e) {
            String l_text;
            Document l_document = e.getDocument();
            try {
                l_text = l_document.getText(0, l_document.getLength()).trim();
            }
            catch (BadLocationException ex) {
                Logger.getLogger(ColorComponentEditPanel.class.getName()).log(Level.WARNING, null, ex);
                return;
            }
            if (!l_text.isEmpty()) {
                int l_rgb;
                try {
                    l_rgb = Integer.parseInt(l_text, 16);
                }
                catch (Exception ex) {
                    return;
                }
                this.updating = true;
                ColorComponentEditPanel.this.model.setRGB(l_rgb);
                this.updating = false;
            }
        }
    }

    private static class ColorComponentDocumentListener
    implements DocumentListener {
        private static boolean ignoreUpdates = false;
        private final ColorModelEditor editor;
        private final int index;

        public ColorComponentDocumentListener(ColorModelEditor editor, int index) {
            this.editor = editor;
            this.index = index;
        }

        public static void setIgnoreUpdates(boolean flag) {
            ignoreUpdates = flag;
        }

        public static boolean isIgnoreUpdates() {
            return ignoreUpdates;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (!ignoreUpdates) {
                this.updateComponent(e);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (!ignoreUpdates) {
                this.updateComponent(e);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        private void updateComponent(DocumentEvent e) {
            String l_text;
            Document l_document = e.getDocument();
            try {
                l_text = l_document.getText(0, l_document.getLength()).trim();
            }
            catch (BadLocationException ex) {
                Logger.getLogger(ColorComponentEditPanel.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
            if (!l_text.isEmpty()) {
                this.editor.setUpdating(true);
                this.editor.getModel().setComponentAsText(this.index, l_text);
                this.editor.setUpdating(false);
            }
        }
    }

    private class ColorModelEditor {
        private final ColorPickerModel.ColorModel model;
        private final ColorComponentField[] fields;
        private boolean updating;

        public ColorModelEditor(ColorPickerModel.ColorModel colorModel) {
            int l_numComponents = colorModel.getNumComponents();
            this.model = colorModel;
            this.fields = new ColorComponentField[l_numComponents];
            this.updating = false;
            for (int i = 0; i < l_numComponents; ++i) {
                ColorComponentField l_field;
                this.fields[i] = l_field = new ColorComponentField(this.model.getComponentParams(i));
                JTextComponent l_component = l_field.getComponent();
                l_component.getDocument().addDocumentListener(new ColorComponentDocumentListener(this, i));
                l_component.addMouseWheelListener(new ColorComponentMouseWheelListener(this, i));
            }
        }

        public List<JTextComponent> listComponents() {
            int l_numComponents = this.model.getNumComponents();
            ArrayList<JTextComponent> l_components = new ArrayList<JTextComponent>();
            for (int i = 0; i < l_numComponents; ++i) {
                l_components.add(this.fields[i].getComponent());
            }
            return l_components;
        }

        public ColorPickerModel.ColorModel getModel() {
            return this.model;
        }

        public boolean isUpdating() {
            return this.updating;
        }

        public void setUpdating(boolean flag) {
            this.updating = flag;
        }

        public ColorComponentField getField(int index) {
            return this.fields[index];
        }

        public void updateFields() {
            for (int i = 0; i < this.getNumComponents(); ++i) {
                ColorComponentField l_field = this.fields[i];
                String l_text = this.model.getComponentAsText(i);
                l_field.getComponent().setText(l_text);
            }
        }

        public int getNumComponents() {
            return this.model.getNumComponents();
        }

        private class ColorComponentField {
            private final JTextComponent component;
            private final ColorPickerModel.ComponentParams params;

            public ColorComponentField(ColorPickerModel.ComponentParams componentParams) {
                NumberFormat l_format = componentParams.getFormat();
                this.params = componentParams;
                this.component = new JTextField(l_format.getMaximumIntegerDigits());
                this.component.addFocusListener(ColorComponentEditPanel.this.defaultTextComponentFocusListener);
            }

            public JTextComponent getComponent() {
                return this.component;
            }

            public ColorPickerModel.ComponentParams getParams() {
                return this.params;
            }
        }
    }
}

