/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.panels;

import com.valeras.colorwheel_harmony.ui.swing.components.JxRoundLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ColorComponentBox
extends JPanel {
    private static final int DEFAULT_GAP = 2;
    private static final int DEFAULT_ROUND = 4;
    private static final String STR_NOT_TEXT = "0";
    private static final String STR_DUMMY_TEXT = "8888";
    private final JLabel label;
    private final JxRoundLabel redBox;
    private final JxRoundLabel greenBox;
    private final JxRoundLabel blueBox;

    public ColorComponentBox(String text) {
        Insets l_insets = new Insets(0, 0, 0, 0);
        Insets l_insets2 = new Insets(0, 2, 0, 0);
        this.setLayout(new GridBagLayout());
        this.label = new JLabel(text);
        this.label.setFont(this.label.getFont().deriveFont(1));
        this.redBox = new JxRoundLabel(STR_NOT_TEXT);
        this.greenBox = new JxRoundLabel(STR_NOT_TEXT);
        this.blueBox = new JxRoundLabel(STR_NOT_TEXT);
        this.redBox.setOpaque(false);
        this.greenBox.setOpaque(false);
        this.blueBox.setOpaque(false);
        this.redBox.setBackground(null);
        this.greenBox.setBackground(null);
        this.blueBox.setBackground(null);
        this.redBox.setHorizontalAlignment(0);
        this.greenBox.setHorizontalAlignment(0);
        this.blueBox.setHorizontalAlignment(0);
        this.redBox.setOutline(this.transparent(Color.red, 128));
        this.greenBox.setOutline(this.transparent(Color.green, 128));
        this.blueBox.setOutline(this.transparent(Color.blue, 128));
        this.redBox.setRound(4);
        this.greenBox.setRound(4);
        this.blueBox.setRound(4);
        this.redBox.setDisplayAlways(true);
        this.greenBox.setDisplayAlways(true);
        this.blueBox.setDisplayAlways(true);
        this.redBox.setText(STR_DUMMY_TEXT);
        Dimension l_size = this.redBox.getPreferredSize();
        this.redBox.setText(STR_NOT_TEXT);
        this.redBox.setPreferredSize(l_size);
        this.greenBox.setPreferredSize(l_size);
        this.blueBox.setPreferredSize(l_size);
        this.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 2, l_insets, 0, 0));
        this.add((Component)this.redBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 2, l_insets2, 0, 0));
        this.add((Component)this.greenBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 12, 2, l_insets2, 0, 0));
        this.add((Component)this.blueBox, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 12, 2, l_insets2, 0, 0));
    }

    private Color transparent(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.label != null) {
            this.label.setForeground(fg);
            this.redBox.setForeground(fg);
            this.greenBox.setForeground(fg);
            this.blueBox.setForeground(fg);
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.label != null) {
            this.label.setBackground(bg);
            this.redBox.setBackground(bg);
            this.greenBox.setBackground(bg);
            this.blueBox.setBackground(bg);
        }
    }

    public void setSampleColor(Color color) {
        String l_red = null;
        String l_green = null;
        String l_blue = null;
        if (color != null) {
            l_red = Integer.toString(color.getRed());
            l_green = Integer.toString(color.getGreen());
            l_blue = Integer.toString(color.getBlue());
        }
        this.redBox.setText(l_red);
        this.greenBox.setText(l_green);
        this.blueBox.setText(l_blue);
    }
}

