/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.panels;

import com.valeras.app_skeleton.Application;
import com.valeras.colorwheel_harmony.actions.AbstractApplicationAction;
import com.valeras.colorwheel_harmony.app_core.AbstractColorWheelApplication;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class CPLicenseOptionPanel
extends JPanel {
    private static final String STR_BUTTON_PURCHASE = "dialog.license_option.button.purchase.caption";
    private static final String STR_PROMPT_SUPPORT = "dialog.license_option.message.contact_support";
    private static final Insets INSETS = new Insets(5, 5, 5, 5);
    private static final Dimension MESSAGE_SIZE = new Dimension(32, 5);
    private final JLabel lblIcon;
    private final JLabel lblContactSupport;
    private final JTextArea txtMessage;
    private final JButton btnPurchase;
    private static final Map<Integer, String> iconMap = new HashMap<Integer, String>();

    public CPLicenseOptionPanel(String message, int messageType) {
        this.setLayout(new BorderLayout());
        Icon l_icon = null;
        if (messageType != -1) {
            l_icon = UIManager.getIcon(iconMap.get(messageType));
        }
        this.lblIcon = new JLabel(l_icon);
        this.txtMessage = new JTextArea(CPLicenseOptionPanel.MESSAGE_SIZE.height, CPLicenseOptionPanel.MESSAGE_SIZE.width);
        this.txtMessage.setFont(this.lblIcon.getFont());
        this.txtMessage.setWrapStyleWord(true);
        this.txtMessage.setLineWrap(true);
        this.txtMessage.setEditable(false);
        this.txtMessage.setText(message);
        this.lblContactSupport = new JLabel(MessageFormat.format(StringTable.get(STR_PROMPT_SUPPORT), StringTable.get(STR_BUTTON_PURCHASE)));
        this.btnPurchase = new JButton(StringTable.get(STR_BUTTON_PURCHASE));
        this.btnPurchase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractApplicationAction l_action = ((AbstractColorWheelApplication)Application.getInstance()).getAction("action.help.purchase");
                l_action.actionPerformed(null);
            }
        });
        JPanel l_panel = new JPanel(new GridBagLayout());
        l_panel.add((Component)this.lblIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, INSETS, 0, 0));
        l_panel.add((Component)this.txtMessage, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, INSETS, 0, 0));
        l_panel.add((Component)this.lblContactSupport, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0));
        l_panel.add((Component)this.btnPurchase, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, INSETS, 0, 0));
        l_panel.add((Component)new JSeparator(0), new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 2, INSETS, 0, 0));
        this.add((Component)l_panel, "Center");
    }

    static {
        iconMap.put(0, "OptionPane.errorIcon");
        iconMap.put(1, "OptionPane.informationIcon");
        iconMap.put(2, "OptionPane.warningIcon");
        iconMap.put(3, "OptionPane.questionIcon");
    }
}

