/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.panels;

import com.valeras.colorwheel_harmony.app_core.AbstractColorWheelApplication;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.ui.swing.AbstractApplicationIconFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class AboutPanel
extends JPanel {
    private static final String STR_VERSION = "dialog.about.version";
    private static final String STR_CAPTION = "dialog.about.caption";
    private static final String STR_DESCRIPTION = "application.description";
    private static final String STR_REGISTERED = "dialog.about.registered_to";
    private static final String STR_COPYRIGHT = "application.copyright_string";
    private static final String STR_COPYRIGHT_EX = "application.copyright_string2";
    private static final Insets insets = new Insets(0, 5, 5, 5);
    private static final Dimension REGINFO_SIZE = new Dimension(32, 3);
    private final Icon icon;
    private final JLabel labelApplication;
    private final JLabel labelVersion;
    private final JLabel labelDescription;
    private final JLabel labelRegistered;
    private final JLabel labelCopyright;
    private final JLabel labelCopyrightEx;
    private final JLabel labelLogo;
    private final JTextArea txtRegInfo;

    public AboutPanel(AbstractColorWheelApplication application, String regInfo) {
        this.setLayout(new BorderLayout());
        this.icon = AbstractApplicationIconFactory.createApplicationIcon(32, 32);
        this.labelLogo = new JLabel();
        this.labelLogo.setIcon(this.icon);
        this.labelApplication = new JLabel(MessageFormat.format(StringTable.get(STR_CAPTION), application.getTitle(), application.getVersion()));
        this.labelApplication.setFont(new Font("Serif", 0, 24));
        this.labelDescription = new JLabel(StringTable.get(STR_DESCRIPTION));
        this.labelDescription.setFont(new Font("Serif", 2, 18));
        this.labelVersion = new JLabel(MessageFormat.format(StringTable.get(STR_VERSION), application.getVersion()));
        this.labelVersion.setFont(new Font("SansSerif", 3, 16));
        this.labelRegistered = new JLabel(StringTable.get(STR_REGISTERED));
        this.labelCopyright = new JLabel(StringTable.get(STR_COPYRIGHT));
        this.labelCopyrightEx = new JLabel(StringTable.get(STR_COPYRIGHT_EX));
        this.txtRegInfo = new JTextArea(AboutPanel.REGINFO_SIZE.height, AboutPanel.REGINFO_SIZE.width);
        this.txtRegInfo.setFont(this.labelRegistered.getFont());
        this.txtRegInfo.setWrapStyleWord(true);
        this.txtRegInfo.setEditable(false);
        this.txtRegInfo.setText(regInfo);
        JPanel l_panel = new JPanel();
        l_panel.setLayout(new GridBagLayout());
        l_panel.add((Component)this.labelApplication, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        l_panel.add((Component)this.labelDescription, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        l_panel.add(Box.createVerticalStrut(8), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        l_panel.add((Component)this.labelRegistered, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        l_panel.add((Component)this.labelLogo, new GridBagConstraints(0, 3, 1, 5, 0.0, 0.0, 16, 0, insets, 0, 0));
        l_panel.add((Component)this.txtRegInfo, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 17, 2, insets, 0, 0));
        l_panel.add(Box.createVerticalStrut(4), new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        l_panel.add((Component)this.labelCopyright, new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        l_panel.add((Component)this.labelCopyrightEx, new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        l_panel.add((Component)new JSeparator(0), new GridBagConstraints(0, 8, 3, 1, 0.0, 0.0, 17, 1, insets, 0, 0));
        this.add((Component)l_panel, "Center");
    }
}

