/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.layout;

import com.valeras.colorwheel_harmony.ui.swing.layout.AbstractCellLayoutManager;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class GridCellLayoutManager
extends AbstractCellLayoutManager {
    protected final int columnCount;
    protected final int rowCount;
    protected Dimension preferredCellSize;
    protected Dimension cellSize;
    protected Insets cellInsets;
    protected final int gap;
    private final Shape[] cellShapes;

    public GridCellLayoutManager(int rows, int columns, Dimension preferredCellSize, Insets cellInsets, float gap) {
        super(rows * columns);
        this.columnCount = columns;
        this.rowCount = rows;
        this.cellSize = this.preferredCellSize = (Dimension)preferredCellSize.clone();
        this.cellInsets = (Insets)cellInsets.clone();
        this.cellShapes = new Shape[this.cellCount];
        this.gap = gap - (float)((int)gap) > 0.0f ? Math.round(gap + 0.5f) : (int)gap;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public Shape getCellShape(int index) {
        return this.cellShapes[index];
    }

    @Override
    public Shape getLayoutShape() {
        return null;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets l_insets = parent.getInsets();
        int l_width = (this.preferredCellSize.width + this.cellInsets.left + this.cellInsets.right) * this.columnCount + l_insets.left + l_insets.right + this.gap * 2;
        int l_height = (this.preferredCellSize.height + this.cellInsets.top + this.cellInsets.bottom) * this.rowCount + l_insets.top + l_insets.bottom + this.gap * 2;
        return new Dimension(l_width, l_height);
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets l_insets = parent.getInsets();
        Rectangle2D l_bounds = parent.getBounds();
        int l_cellWidth = (int)((((RectangularShape)l_bounds).getWidth() - (double)(this.gap * 2) - (double)(l_insets.left + l_insets.right) - (double)((this.cellInsets.left + this.cellInsets.right) * this.columnCount)) / (double)this.columnCount);
        int l_cellHeight = (int)((((RectangularShape)l_bounds).getHeight() - (double)(this.gap * 2) - (double)(l_insets.top + l_insets.bottom) - (double)((this.cellInsets.top + this.cellInsets.bottom) * this.rowCount)) / (double)this.rowCount);
        this.cellSize = new Dimension(l_cellWidth, l_cellHeight);
        for (int r = 0; r < this.rowCount; ++r) {
            for (int c = 0; c < this.columnCount; ++c) {
                int l_index = r * this.columnCount + c;
                int l_x = this.gap + l_insets.left + this.cellInsets.left * (c + 1) + (this.cellInsets.right + l_cellWidth) * c;
                int l_y = this.gap + l_insets.top + this.cellInsets.top * (r + 1) + (this.cellInsets.bottom + l_cellHeight) * r;
                l_bounds = new Rectangle2D.Double(l_x, l_y, l_cellWidth, l_cellHeight);
                this.cellBounds[l_index] = l_bounds;
                this.cellShapes[l_index] = this.createCellShape(l_index, l_bounds);
            }
        }
    }

    protected Shape createCellShape(int index, Rectangle2D bounds) {
        Rectangle2D.Double l_shape = new Rectangle2D.Double();
        ((Rectangle2D)l_shape).setRect(bounds);
        return l_shape;
    }

    @Override
    public boolean isEqualShapes() {
        return true;
    }
}

