/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.layout;

import com.valeras.colorwheel_harmony.ui.swing.layout.CellLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public abstract class AbstractCellLayoutManager
implements CellLayoutManager {
    protected final int cellCount;
    protected final Rectangle2D[] cellBounds;

    protected AbstractCellLayoutManager(int numCells) {
        this.cellCount = numCells;
        this.cellBounds = new Rectangle2D[this.cellCount];
    }

    @Override
    public int getCellCount() {
        return this.cellCount;
    }

    @Override
    public Rectangle2D getCellBounds(int index) {
        return this.cellBounds[index];
    }

    protected void setCellBounds(int index, Rectangle2D bounds) {
        this.cellBounds[index] = bounds;
    }

    @Override
    public Shape getCellShape(int index) {
        return this.cellBounds[index];
    }

    @Override
    public Shape getLayoutShape() {
        return null;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public int cellAt(Point pnt) {
        for (int i = 0; i < this.getCellCount(); ++i) {
            if (!this.getCellBounds(i).contains(pnt)) continue;
            return i;
        }
        return -1;
    }
}

