/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.icons.text_renderer;

import com.valeras.colorwheel_harmony.ui.swing.icons.text_renderer.TextRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import javax.swing.SwingConstants;

public class SimpleTextRenderer
implements TextRenderer,
SwingConstants {
    private static final float DEFAULT_LINE_SPACING = 1.0f;
    protected Font font;
    private float lineSpacing = 1.0f;
    private int horizontalAlignment = 2;
    private int verticalAlignment = 1;
    private int textAlignment = 2;
    private boolean boldCaption = false;

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(float lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public void setCaptionBold(boolean flag) {
        this.boldCaption = flag;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public int getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(int textAlignment) {
        this.textAlignment = textAlignment;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    @Override
    public void renderText(Graphics gr, Rectangle2D bounds, String text, Color color) {
        int i;
        Graphics l_gr = gr.create();
        float l_x = 0.0f;
        float l_y = 0.0f;
        float l_textWidth = 0.0f;
        if (text == null) {
            return;
        }
        String[] l_lines = text.split("\n");
        l_gr.setFont(this.font);
        FontMetrics l_metrics = gr.getFontMetrics(this.font);
        int l_fontHeight = l_metrics.getHeight();
        int l_fontAscent = l_metrics.getMaxAscent();
        int l_fontDescent = l_metrics.getMaxDescent();
        float[] l_lineWidth = new float[l_lines.length];
        for (i = 0; i < l_lines.length; ++i) {
            float l_w;
            Rectangle2D l_rect = l_metrics.getStringBounds(l_lines[i], gr);
            l_lineWidth[i] = l_w = (float)l_rect.getWidth();
            if (!(l_w > l_textWidth)) continue;
            l_textWidth = l_w;
        }
        float l_lineSpacing = (float)l_fontHeight * this.getLineSpacing();
        switch (this.verticalAlignment) {
            case 3: {
                l_y = (float)(bounds.getMaxY() - (double)l_fontDescent - (double)(l_lineSpacing * (float)(l_lines.length - 1)));
                break;
            }
            case 0: {
                l_y = (float)(bounds.getCenterY() - (double)(l_lineSpacing * (float)l_lines.length / 2.0f)) + (float)l_fontAscent;
                break;
            }
            case 1: {
                l_y = (float)(bounds.getMinY() + (double)l_fontAscent);
                break;
            }
            default: {
                l_y = (float)bounds.getY();
            }
        }
        switch (this.horizontalAlignment) {
            case 2: {
                l_x = (float)bounds.getX();
                break;
            }
            case 0: {
                l_x = (float)(bounds.getX() + (bounds.getWidth() - (double)l_textWidth) / 2.0);
                break;
            }
            case 4: {
                l_x = (float)bounds.getMaxX() - l_textWidth;
                break;
            }
            default: {
                l_x = (float)bounds.getX();
            }
        }
        l_gr.setColor(color);
        for (i = 0; i < l_lines.length; ++i) {
            float l_dx = 0.0f;
            String l_text = l_lines[i];
            float l_w = l_lineWidth[i];
            switch (this.textAlignment) {
                case 2: {
                    break;
                }
                case 0: {
                    l_dx = (l_textWidth - l_w) / 2.0f;
                    break;
                }
                case 4: {
                    l_dx = l_textWidth - l_w;
                }
            }
            l_gr.drawString(l_text, (int)(l_x + l_dx), (int)(l_y + l_lineSpacing * (float)i));
        }
        l_gr.dispose();
    }

    @Override
    public int getTextHeight(int lines, Graphics g) {
        FontMetrics l_metrics = g.getFontMetrics(this.font);
        int l_fontHeight = l_metrics.getHeight();
        int l_fontAscent = l_metrics.getMaxAscent();
        int l_fontDescent = l_metrics.getMaxDescent();
        int l_height = (int)((float)l_fontHeight + (float)((lines - 1) * l_fontHeight) * this.getLineSpacing());
        return l_height;
    }
}

