/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.icons.paint_buttons;

import com.valeras.colorwheel_harmony.ui.swing.components.HotSpotButtonIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class PaintButtonRGBY
extends HotSpotButtonIcon {
    private final int circleSize;

    public PaintButtonRGBY(int w, int h, Color color, float circleScale) {
        super(w, h, color);
        this.circleSize = Math.round((float)h * circleScale);
    }

    @Override
    public int getHotSpotRegion(int x, int y) {
        return x / (this.getIconWidth() / 4);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D l_gr2 = (Graphics2D)g.create();
        Color[] l_colors = new Color[]{Color.RED, Color.GREEN.darker(), Color.BLUE, new Color(16242176)};
        Color l_color2 = this.createTranslucentColor(this.getColor());
        int l_width = this.getIconWidth() - 1;
        int l_height = this.getIconHeight() - 1;
        int l_dx = Math.round((float)l_width / 4.0f);
        int l_offset = (l_dx - this.circleSize) / 2;
        int l_y = (l_height - this.circleSize) / 2;
        l_gr2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        l_gr2.setStroke(new BasicStroke(1.5f));
        for (int i = 0; i < 4; ++i) {
            l_gr2.setColor(this.isActive() && this.getActiveRegion() == i ? l_colors[i] : l_color2);
            l_gr2.fillOval(x + l_dx * i + l_offset, l_y, this.circleSize, this.circleSize);
        }
        l_gr2.dispose();
    }
}

