/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.icons;

import com.valeras.colorwheel_harmony.ui.shapes.StrokeAware;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import javax.swing.Icon;

public class ColorWheelIcon
implements Icon {
    private int width;
    private int height;
    private final Color[] colors;
    private final Color outline;
    private Stroke stroke;
    private double angleStart;

    public ColorWheelIcon(int width, int height, Color[] colors, double rotate, Color outline, Stroke stroke) {
        this.width = width;
        this.height = height;
        this.colors = Arrays.copyOf(colors, colors.length);
        this.angleStart = rotate;
        this.outline = outline;
        this.stroke = stroke;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D l_g2 = (Graphics2D)g.create();
        Ellipse2D.Float l_shape = new Ellipse2D.Float();
        int l_count = this.colors.length;
        double l_extent = 360.0 / (double)l_count;
        l_shape.setFrame(StrokeAware.createStrokeAwareRectangle(new Rectangle2D.Double(x, y, this.width - 1, this.height - 1), this.stroke));
        l_g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = 0; i < l_count; ++i) {
            Arc2D.Double l_arc = new Arc2D.Double(l_shape.getBounds2D(), this.angleStart + l_extent * (double)i, l_extent, 2);
            l_g2.setPaint(this.colors[i]);
            l_g2.fill(l_arc);
        }
        if (this.stroke != null) {
            l_g2.setStroke(this.stroke);
        }
        l_g2.setColor(this.outline);
        l_g2.draw(l_shape);
        l_g2.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

