/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.icons;

import com.valeras.color_combine.model.ColorScheme;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.Icon;

public class ColorSchemeIcon
implements Icon {
    private final int width;
    private final int height;
    private final Color paint;
    private final Color outline;
    private final Ellipse2D shape;
    private final Arc2D[] sectors;
    private final Stroke stroke;

    public ColorSchemeIcon(ColorScheme colorScheme, int width, int height, Color outline, Color paint, Stroke stroke) {
        ArrayList<Arc2D.Double> l_sectors = new ArrayList<Arc2D.Double>();
        int dx = 0;
        int dy = 0;
        this.width = width;
        this.height = height;
        this.paint = paint;
        this.outline = outline;
        this.stroke = stroke;
        if (stroke instanceof BasicStroke) {
            dx = dy = (int)((double)((BasicStroke)stroke).getLineWidth() / 2.0 + 0.5);
        }
        this.shape = new Ellipse2D.Double(dx, dy, width - dx * 2, height - dy * 2);
        Rectangle2D l_frame = this.shape.getFrame();
        double l_angleExtent = 30.0;
        boolean[] l_mask = colorScheme.getMask();
        double l_rotate = colorScheme.getAlignmentAngle();
        for (int i = 0; i < l_mask.length; ++i) {
            if (!l_mask[i]) continue;
            Arc2D.Double l_arc = new Arc2D.Double(l_frame, (double)i * l_angleExtent + l_rotate, l_angleExtent, 2);
            l_sectors.add(l_arc);
        }
        this.sectors = new Arc2D[l_sectors.size()];
        l_sectors.toArray(this.sectors);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D l_gr = (Graphics2D)g.create();
        AffineTransform l_tx = AffineTransform.getTranslateInstance(x, y);
        l_gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        l_gr.setStroke(this.stroke);
        for (Arc2D arc : this.sectors) {
            Shape l_shape = l_tx.createTransformedShape(arc);
            l_gr.setPaint(this.paint);
            l_gr.fill(l_shape);
            l_gr.setColor(this.outline);
            l_gr.draw(l_shape);
        }
        l_gr.setColor(this.outline);
        l_gr.draw(l_tx.createTransformedShape(this.shape));
        l_gr.dispose();
    }
}

