/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.icons;

import com.valeras.colorwheel_harmony.ui.shapes.StrokeAware;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import javax.swing.Icon;

public class ColorPieIcon
implements Icon {
    private final int width;
    private final int height;
    private final int count;
    private final Color[] colors;
    private final Ellipse2D frame;
    private final Arc2D[] sectors;
    private final Color outline;
    private final Stroke stroke;

    public ColorPieIcon(int width, int height, Color[] colors, Color outline, Stroke stroke) {
        this.count = colors.length;
        this.width = width;
        this.height = height;
        this.colors = Arrays.copyOf(colors, colors.length);
        this.outline = outline;
        this.stroke = stroke;
        this.frame = new Ellipse2D.Double();
        this.frame.setFrame(StrokeAware.createStrokeAwareRectangle(new Rectangle2D.Double(0.0, 0.0, width - 1, height - 1), stroke));
        this.sectors = new Arc2D[this.count];
        float l_angleStart = 0.0f;
        float l_angleExtent = 360.0f / (float)this.count;
        for (int i = 0; i < this.count; ++i) {
            Arc2D.Float l_arc = new Arc2D.Float(this.frame.getBounds2D(), l_angleStart + (float)i * l_angleExtent, l_angleExtent, 2);
            this.sectors[i] = l_arc;
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D l_gr = (Graphics2D)g.create();
        AffineTransform l_tx = AffineTransform.getTranslateInstance(x, y);
        l_gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        l_gr.setStroke(this.stroke);
        Shape l_frame = l_tx.createTransformedShape(this.frame);
        for (int i = 0; i < this.count; ++i) {
            Shape l_arc = l_tx.createTransformedShape(this.sectors[i]);
            l_gr.setPaint(this.colors[i]);
            l_gr.fill(l_arc);
        }
        l_gr.setColor(this.outline);
        l_gr.draw(l_frame);
        l_gr.dispose();
    }
}

