/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.icons;

import com.valeras.colorwheel_harmony.ui.shapes.StrokeAware;
import com.valeras.colorwheel_harmony.ui.swing.icons.AbstractColorCardIcon;
import com.valeras.colorwheel_harmony.ui.swing.icons.text_renderer.SimpleTextRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class BasicColorCardIcon
extends AbstractColorCardIcon {
    private int arcw;
    private int arch;
    private final SimpleTextRenderer textRenderer;
    private Shape shape;
    private Shape userShape;
    private Point selectIconPnt;
    private float strokeWidth;
    private int strokeWidthHalf;
    protected Area labelBoxArea;
    protected Point commentTextPnt;
    protected Rectangle2D labelTextRect;
    protected Rectangle2D commentTextRect;

    public BasicColorCardIcon(int width, int height, Color background, Color foreground, Color outline, int arcw, int arch) {
        super(width, height, background, foreground, outline);
        this.arcw = arcw;
        this.arch = arch;
        this.shape = null;
        this.userShape = null;
        this.selectIconPnt = null;
        this.strokeWidth = 1.0f;
        this.labelBoxArea = null;
        this.commentTextRect = null;
        this.labelTextRect = null;
        this.textRenderer = new SimpleTextRenderer();
        this.textRenderer.setFont(this.getFont());
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.textRenderer.setFont(font);
    }

    protected Shape createShape() {
        Shape l_shape = null;
        Rectangle2D l_frame = StrokeAware.createStrokeAwareRectangle2D(new Rectangle(0, 0, this.width, this.height), this.getStroke());
        l_shape = this.userShape != null ? this.userShape : new RoundRectangle2D.Double(l_frame.getX(), l_frame.getY(), l_frame.getWidth(), l_frame.getHeight(), this.arcw, this.arch);
        return l_shape;
    }

    public Shape getShape(int x, int y) {
        return AffineTransform.getTranslateInstance(x, y).createTransformedShape(this.shape != null && !this.isInvalidated() ? this.shape : this.createShape());
    }

    public void setShape(Shape shape) {
        this.userShape = shape;
        this.shape = null;
        this.invalidate();
    }

    @Override
    public void setHorizontalTextAlignment(int alignment) {
        super.setHorizontalTextAlignment(alignment);
        this.textRenderer.setHorizontalAlignment(alignment);
    }

    private Point getSelectIconPnt() {
        Rectangle l_bounds = this.shape.getBounds();
        Point l_pnt = new Point();
        switch (this.selectIconPosition) {
            case 8: {
                l_pnt.x = l_bounds.x + this.selectIconGap + this.strokeWidthHalf;
                l_pnt.y = l_bounds.y + this.selectIconGap + this.strokeWidthHalf;
                break;
            }
            case 2: {
                l_pnt.x = l_bounds.x + l_bounds.width - this.selectIcon.getIconWidth() - this.selectIconGap - this.strokeWidthHalf;
                l_pnt.y = l_bounds.y + this.selectIconGap + this.strokeWidthHalf;
                break;
            }
            case 6: {
                l_pnt.x = l_bounds.x + this.selectIconGap + this.strokeWidthHalf;
                l_pnt.y = l_bounds.y + l_bounds.height - this.selectIcon.getIconHeight() - this.selectIconGap - this.strokeWidthHalf;
                break;
            }
            case 4: {
                l_pnt.x = l_bounds.x + l_bounds.width - this.selectIcon.getIconWidth() - this.selectIconGap - this.strokeWidthHalf;
                l_pnt.y = l_bounds.y + l_bounds.height - this.selectIcon.getIconHeight() - this.selectIconGap - this.strokeWidthHalf;
                break;
            }
            default: {
                throw new RuntimeException("Invalid location of select icon.");
            }
        }
        return l_pnt;
    }

    @Override
    protected void doLayout(Graphics g) {
        Stroke l_stroke = this.getStroke();
        Insets l_textInsets = this.getTextInsets();
        int l_margin = this.arcw / 2 > this.strokeWidthHalf ? this.arcw / 2 : this.strokeWidthHalf;
        FontMetrics l_fontMetrics = g.getFontMetrics(this.getFont());
        int l_fontHeight = l_fontMetrics.getHeight();
        int l_fontAscent = l_fontMetrics.getAscent();
        int l_fontDescent = l_fontMetrics.getDescent();
        this.strokeWidth = l_stroke != null && l_stroke instanceof BasicStroke ? ((BasicStroke)l_stroke).getLineWidth() : 1.0f;
        this.strokeWidthHalf = (int)(this.strokeWidth > 1.0f ? this.strokeWidth / 2.0f + 0.5f : 0.0f);
        this.shape = this.createShape();
        Rectangle2D l_bounds = this.shape.getBounds2D();
        int l_h = this.textRenderer.getTextHeight(this.textRows, g) + l_textInsets.top + l_textInsets.bottom + this.strokeWidthHalf;
        int l_w = (int)l_bounds.getWidth();
        int l_x = (int)l_bounds.getX();
        int l_y = (int)l_bounds.getY();
        Rectangle2D.Double l_rect = new Rectangle2D.Double(l_x, l_y, l_w, l_h);
        this.labelBoxArea = new Area(l_rect);
        this.labelBoxArea.intersect(new Area(this.shape));
        this.labelTextRect = new Rectangle(l_x + l_margin + l_textInsets.left, l_y + this.strokeWidthHalf + l_textInsets.top, l_w -= l_margin * 2 + l_textInsets.left + l_textInsets.right + 1, l_h -= l_textInsets.top + l_textInsets.bottom + this.strokeWidthHalf);
        l_h = l_fontHeight + l_textInsets.top + l_textInsets.bottom;
        l_w = (int)(l_bounds.getWidth() - (double)(l_margin * 2)) - 1;
        l_x = (int)(l_bounds.getX() + (double)l_margin);
        l_y = (int)(l_bounds.getY() + l_bounds.getHeight() - (double)l_h - (double)this.strokeWidthHalf);
        this.commentTextRect = new Rectangle(l_x, l_y, l_w, l_h);
        this.commentTextPnt = new Point(l_x + l_textInsets.left, l_y + l_textInsets.top + l_fontAscent);
        if (this.selectIcon != null) {
            this.selectIconPnt = this.getSelectIconPnt();
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D l_gt;
        Rectangle l_bounds;
        Graphics2D l_g2 = (Graphics2D)g.create();
        if (this.isInvalidated()) {
            this.validate(l_g2);
        }
        String l_labelText = this.getLabelText();
        String l_commentText = this.getCommentText();
        Font l_font = this.getFont();
        Stroke l_stroke = this.getStroke();
        AffineTransform l_tx = AffineTransform.getTranslateInstance(x, y);
        Shape l_frame = l_tx.createTransformedShape(this.shape);
        Area l_paintArea = new Area(l_frame);
        Area l_labelArea = this.labelBoxArea.createTransformedArea(l_tx);
        l_paintArea.subtract(l_labelArea);
        this.setRenderingHints(l_g2);
        Paint l_paint = this.paint != null ? this.paint : this.noPaint;
        l_g2.setPaint(l_paint);
        l_g2.fill(l_paintArea);
        if (this.secondColor != null) {
            Rectangle l_rect = l_paintArea.getBounds();
            int l_extent = (int)(l_rect.getWidth() / 4.0);
            Path2D.Float l_path = new Path2D.Float();
            l_g2.setPaint(this.secondColor);
            ((Path2D)l_path).moveTo(l_rect.getMaxX(), l_rect.getMaxY());
            ((Path2D)l_path).lineTo(l_rect.getMaxX(), l_rect.getMaxY() - (double)l_extent);
            ((Path2D)l_path).lineTo(l_rect.getMaxX() - (double)l_extent, l_rect.getMaxY());
            l_path.closePath();
            l_g2.fill(l_path);
        }
        l_g2.setPaint(this.background);
        l_g2.fill(l_labelArea);
        if (l_labelText != null) {
            l_bounds = l_tx.createTransformedShape(this.labelTextRect).getBounds();
            l_gt = (Graphics2D)l_g2.create();
            l_gt.clipRect(l_bounds.x, l_bounds.y, l_bounds.width, l_bounds.height);
            this.textRenderer.renderText(l_gt, l_bounds, l_labelText, this.foreground);
            l_gt.dispose();
        }
        if (l_commentText != null) {
            l_bounds = l_tx.createTransformedShape(this.commentTextRect).getBounds();
            l_gt = (Graphics2D)l_g2.create();
            l_gt.setFont(l_font);
            l_gt.clipRect(l_bounds.x, l_bounds.y, l_bounds.width, l_bounds.height);
            l_gt.setColor(this.createDistinctColor(l_paint));
            l_gt.drawString(l_commentText, x + this.commentTextPnt.x, y + this.commentTextPnt.y);
            l_gt.dispose();
        }
        if (this.outlineColor != null) {
            if (l_stroke != null) {
                l_g2.setStroke(l_stroke);
            }
            l_g2.setColor(this.outlineColor);
            l_g2.draw(l_frame);
        }
        if (this.isSelected() && this.selectIcon != null) {
            this.selectIcon.paintIcon(c, l_g2, x + this.selectIconPnt.x, y + this.selectIconPnt.y);
        }
        l_g2.dispose();
    }
}

