/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.icons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public abstract class AbstractColorCardIcon
implements Icon,
SwingConstants {
    private static final String UI_DEFAULTS_LABELFONT = "Label.font";
    private static final Insets DEFAULT_TEXT_INSETS = new Insets(0, 0, 0, 0);
    private static final int DEFAULT_SELECT_ICON_GAP = 1;
    protected int width;
    protected int height;
    private Font font;
    private String labelText;
    private String commentText;
    protected int textRows;
    protected Insets textInsets;
    protected Color background;
    protected Color foreground;
    protected Color outlineColor;
    protected Color secondColor;
    protected Paint paint;
    protected Paint noPaint;
    private Stroke stroke;
    private boolean selected;
    protected Icon selectIcon;
    protected int selectIconPosition;
    protected int selectIconGap;
    private Set<Map.Entry<RenderingHints.Key, Object>> renderingHints;
    private boolean invalidated;

    protected AbstractColorCardIcon(int width, int height, Color background, Color foreground, Color outline) {
        this.width = width;
        this.height = height;
        this.commentText = null;
        this.labelText = null;
        this.textRows = 1;
        this.textInsets = DEFAULT_TEXT_INSETS;
        this.background = background;
        this.foreground = foreground;
        this.outlineColor = outline;
        this.secondColor = null;
        this.stroke = null;
        this.paint = null;
        this.noPaint = null;
        this.selected = false;
        this.selectIcon = null;
        this.selectIconGap = 1;
        this.selectIconPosition = 4;
        this.renderingHints = null;
        this.font = UIManager.getFont(UI_DEFAULTS_LABELFONT);
        this.invalidated = true;
    }

    public void setFont(Font font) {
        this.font = font;
        this.invalidate();
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    protected void invalidate() {
        this.invalidated = true;
    }

    protected void setInvalidated(boolean flag) {
        this.invalidated = flag;
    }

    protected boolean isInvalidated() {
        return this.invalidated;
    }

    public void paintIcon(Component c, Graphics g, int x, int y, Paint paint, String text, boolean selected) {
        this.labelText = text;
        this.paint = paint;
        this.selected = selected;
        this.paintIcon(c, g, x, y);
    }

    public void setSize(Dimension size) {
        this.width = size.width;
        this.height = size.height;
        this.invalidate();
    }

    public void setCommentText(String comment) {
        this.commentText = comment;
    }

    public String getCommentText() {
        return this.commentText;
    }

    public void setHorizontalTextAlignment(int alignment) {
    }

    public void setHorizontalCommentAlignment(int alignment) {
    }

    public void setNoPaint(Paint paint) {
        this.noPaint = paint;
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
    }

    public void setSecondColor(Color color) {
        this.secondColor = color;
    }

    public Color getSecondColor() {
        return this.secondColor;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public void setRenderingHints(Map<RenderingHints.Key, Object> hints) {
        this.renderingHints = hints.entrySet();
    }

    protected void setRenderingHints(Graphics2D g) {
        if (this.renderingHints != null) {
            for (Map.Entry<RenderingHints.Key, Object> h : this.renderingHints) {
                g.setRenderingHint(h.getKey(), h.getValue());
            }
        }
    }

    public void setSelectIcon(Icon icon) {
        this.selectIcon = icon;
    }

    public void setSelectIconGap(int gap) {
        this.selectIconGap = gap;
    }

    public void setSelectIconPosition(int position) {
        this.selectIconPosition = position;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        this.invalidate();
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public Insets getTextInsets() {
        return this.textInsets;
    }

    public void setLabelText(String text) {
        this.labelText = text;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public void setTextRows(int rows) {
        this.textRows = rows;
        this.invalidate();
    }

    protected void validate(Graphics g) {
        this.doLayout(g);
        this.setInvalidated(false);
    }

    protected abstract void doLayout(Graphics var1);

    protected Color createDistinctColor(Paint paint) {
        Color l_color = Color.black;
        if (paint instanceof Color) {
            l_color = (Color)paint;
            float[] l_hsb = Color.RGBtoHSB(l_color.getRed(), l_color.getGreen(), l_color.getBlue(), null);
            l_color = (double)l_hsb[2] > 0.5 ? Color.black : Color.white;
        } else if (paint.equals(this.noPaint)) {
            l_color = Color.darkGray;
        }
        return l_color;
    }
}

