/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.dialogs;

import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.ui.swing.AbstractApplicationIconFactory;
import com.valeras.colorwheel_harmony.ui.swing.dialogs.DialogConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class TextViewDialog
extends JDialog
implements DialogConstants {
    private static final Insets insets = new Insets(0, 5, 5, 5);
    private final JButton button;
    private final JTextPane textPane;

    public TextViewDialog(JFrame owner, String title, URL page, boolean modal, int option) {
        super(owner, title, modal);
        this.setIconImage(AbstractApplicationIconFactory.getInstance().getApplicationIconImage());
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.textPane.addHyperlinkListener(new DefaultHyperlinkListener());
        try {
            this.textPane.setPage(page);
        }
        catch (IOException ex) {
            Logger.getLogger(TextViewDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        JScrollPane l_scrollPane = new JScrollPane(this.textPane);
        l_scrollPane.setPreferredSize(new Dimension(640, 480));
        this.add((Component)l_scrollPane, "Center");
        this.button = option == 0 ? new JButton(StringTable.get("dialog.button.ok")) : null;
        if (this.button != null) {
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextViewDialog.this.dispose();
                }
            });
            Box l_box = Box.createHorizontalBox();
            l_box.add(Box.createHorizontalGlue());
            l_box.add(this.button);
            l_box.setBorder(BorderFactory.createEmptyBorder(7, 5, 5, 5));
            this.add((Component)l_box, "South");
        }
        this.pack();
    }

    class DefaultHyperlinkListener
    implements HyperlinkListener {
        DefaultHyperlinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JTextPane pane = (JTextPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    try {
                        pane.setPage(e.getURL());
                    }
                    catch (IOException ex) {
                        Logger.getLogger(TextViewDialog.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }
}

