/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.dialogs;

import com.valeras.colorwheel_harmony.app_core.ApplicationSettings;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.ui.swing.AbstractApplicationIconFactory;
import com.valeras.colorwheel_harmony.ui.swing.panels.options_dialog.AbstractOptionsPanel;
import com.valeras.colorwheel_harmony.ui.swing.panels.options_dialog.OptionsAdvancedPanel;
import com.valeras.colorwheel_harmony.ui.swing.panels.options_dialog.OptionsGeneralPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

@Deprecated
public class OptionsDialog
extends JDialog {
    private static final String STR_TITLE = "dialog.options.title";
    private static final String STR_CATEGORY = "dialog.options.panel.category.title";
    private static final String STR_OPTIONS = "dialog.options.panel.options.title";
    private final ArrayList<AbstractOptionsPanel> panels;
    private final ArrayList<AbstractButton> buttons;
    private final ButtonGroup buttonGroup;
    private final JPanel buttonPane;
    private final JPanel optionsPane;
    private final JPanel categoryPanel;
    private final JScrollPane contentPanel;
    private final JButton btnOk;
    private final JButton btnCancel;
    private int selectedCategoryIndex;
    private final boolean basicAppearance;

    public OptionsDialog(JFrame owner, ApplicationSettings settings) {
        super(owner, StringTable.get(STR_TITLE), true);
        this.basicAppearance = settings.getDefaultLNFEnabled();
        this.setIconImage(AbstractApplicationIconFactory.getInstance().getApplicationIconImage());
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.panels = new ArrayList();
        this.buttons = new ArrayList();
        this.buttonGroup = new ButtonGroup();
        this.categoryPanel = new JPanel();
        this.categoryPanel.setLayout(new BorderLayout());
        this.categoryPanel.setBorder(this.createPaneBorder(StringTable.get(STR_CATEGORY), this.basicAppearance));
        this.buttonPane = new JPanel();
        this.buttonPane.setLayout(new GridBagLayout());
        this.categoryPanel.add((Component)this.buttonPane, "North");
        this.contentPanel = new JScrollPane();
        this.contentPanel.setBorder(this.createPaneBorder(StringTable.get(STR_OPTIONS), this.basicAppearance));
        this.contentPanel.setPreferredSize(new Dimension(400, 300));
        this.optionsPane = new JPanel();
        this.optionsPane.setLayout(new FlowLayout(0));
        if (settings.getDefaultLNFEnabled()) {
            this.optionsPane.setBackground(Color.white);
        }
        this.btnOk = new JButton(StringTable.get("dialog.button.ok"));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (AbstractOptionsPanel p : OptionsDialog.this.panels) {
                    p.applySettings();
                }
                OptionsDialog.this.dispose();
            }
        });
        this.btnCancel = new JButton(StringTable.get("dialog.button.cancel"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsDialog.this.dispose();
            }
        });
        if (this.btnOk.getText().length() > this.btnCancel.getText().length()) {
            this.btnCancel.setPreferredSize(this.btnOk.getPreferredSize());
        } else {
            this.btnOk.setPreferredSize(this.btnCancel.getPreferredSize());
        }
        this.createCategory(new OptionsGeneralPanel(settings));
        this.createCategory(new OptionsAdvancedPanel(settings));
        Box l_box = Box.createHorizontalBox();
        l_box.add(Box.createHorizontalGlue());
        l_box.add(this.btnOk);
        l_box.add(Box.createHorizontalStrut(5));
        l_box.add(this.btnCancel);
        l_box.setBorder(BorderFactory.createEmptyBorder(7, 5, 7, 5));
        this.add((Component)this.categoryPanel, "West");
        this.add((Component)this.contentPanel, "Center");
        this.add((Component)l_box, "South");
        this.setSelectedCategory(0, true);
        this.getRootPane().setDefaultButton(this.btnOk);
        this.pack();
    }

    private AbstractButton createCategory(AbstractOptionsPanel panel) {
        Insets l_buttonInsets = new Insets(5, 5, 0, 5);
        this.panels.add(panel);
        AbstractButton l_button = this.createCategoryButton(panel);
        this.buttons.add(l_button);
        this.buttonGroup.add(l_button);
        this.buttonPane.add((Component)l_button, new GridBagConstraints(0, this.buttons.indexOf(l_button), 2, 1, 0.0, 0.0, 17, 2, l_buttonInsets, 0, 0));
        return l_button;
    }

    private Border createPaneBorder(String title, boolean basic) {
        AbstractBorder l_border;
        if (basic) {
            Border l_insetsBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
            Border l_lineBorder = BorderFactory.createEtchedBorder();
            l_border = new CompoundBorder(l_insetsBorder, l_lineBorder);
        } else {
            l_border = BorderFactory.createTitledBorder(title);
        }
        return l_border;
    }

    protected int getSelectedCategoryIndex() {
        return this.selectedCategoryIndex;
    }

    private void setSelectedCategory(int index, boolean selectButton) {
        AbstractButton l_button = this.buttons.get(index);
        if (selectButton) {
            this.buttonGroup.setSelected(l_button.getModel(), true);
        }
        AbstractOptionsPanel l_panel = this.panels.get(index);
        this.optionsPane.removeAll();
        this.optionsPane.add(l_panel);
        this.contentPanel.setViewportView(this.optionsPane);
        this.selectedCategoryIndex = index;
    }

    private AbstractButton createCategoryButton(AbstractOptionsPanel panel) {
        JToggleButton l_button = new JToggleButton(panel.getName());
        l_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int l_index = OptionsDialog.this.buttons.indexOf(e.getSource());
                OptionsDialog.this.setSelectedCategory(l_index, false);
            }
        });
        return l_button;
    }
}

