/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.components.colorwheel_renderer;

import com.valeras.color_combine.model.ColorSpectrum;
import com.valeras.color_combine.view.geometry.Pie2D;
import com.valeras.color_combine.view.renderer.AbstractColorWheelRenderer;
import com.valeras.color_combine.view.renderer.ColorWheelSkin;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.ui.swing.components.colorwheel_renderer.AbstractColorWheelSkin;
import com.valeras.colorwheel_harmony.ui.swing.renderer.TextStroke;
import com.valeras.effects2d.DropShadowIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;

public class ColorWheelSwingRenderer
extends AbstractColorWheelRenderer
implements Icon {
    private static final int WC_ALPHA = 150;
    private static final float TEMPERATURE_ARC_THICKNESS = 3.0f;
    private static final Color COOL_COLOR = new Color(Color.blue.getRed(), Color.blue.getGreen(), Color.blue.getBlue(), 150);
    private static final Color WARM_COLOR = new Color(Color.red.getRed(), Color.red.getGreen(), Color.red.getBlue(), 150);
    private static final String WARM_COLORS = "colors.warm";
    private static final String COOL_COLORS = "colors.cool";
    private static final String[] tints = new String[]{"color_wheel.skin.shade", "color_wheel.skin.tone", "color_wheel.skin.tint", "color_wheel.skin.pure_color"};
    private final Font font;
    private Point2D dropShadowDirection;
    private float shadowOpacity;
    private Color gridlineColor;
    private float gridlineWidth;
    private Area coverOutline;
    private Ellipse2D coverHole;
    private DropShadowIcon dropShadow;
    private int tintsIndex;

    public ColorWheelSwingRenderer(int width, int height, AbstractColorWheelSkin skin, Font font, Point2D dropShadowDirection, float shadowOpacity) {
        super(width, height, (ColorWheelSkin)skin);
        this.font = font;
        this.dropShadowDirection = dropShadowDirection;
        this.shadowOpacity = shadowOpacity;
        this.coverOutline = null;
        this.coverHole = null;
        this.dropShadow = null;
        this.setInvalidated(true);
    }

    public Pie2D getGeometry() {
        return this.geometry;
    }

    public void setGridlineColor(Color color) {
        this.gridlineColor = color;
    }

    public void setGridlineWidth(float width) {
        this.gridlineWidth = width;
    }

    protected void validate() {
        boolean[] l_mask = this.colorWheel.getColorScheme().getMask();
        super.validate();
        this.coverOutline = new Area((Shape)this.geometry);
        this.coverHole = this.geometry.getInnerEllipse();
        double cx = this.coverHole.getCenterX();
        double cy = this.coverHole.getCenterY();
        this.coverHole.setFrameFromCenter(cx, cy, cx + this.coverHole.getWidth() / 4.0, cy + this.coverHole.getHeight() / 4.0);
        this.coverOutline.subtract(new Area(this.coverHole));
        double l_angleStart = this.colorWheel.getColorScheme().getAlignmentAngle();
        int l_index = 0;
        int l_count = 0;
        for (int i = 0; i < l_mask.length; ++i) {
            if (l_mask[i]) {
                ++l_count;
                continue;
            }
            if (l_count > 0) {
                this.coverOutline.subtract(new Area(this.geometry.getSlice(l_index, l_angleStart, l_count)));
            }
            l_index = i + 1;
            l_count = 0;
        }
        if (l_count > 0) {
            this.coverOutline.subtract(new Area(this.geometry.getSlice(l_index, l_angleStart, l_count)));
        }
        for (int i = 0; i < l_mask.length; ++i) {
            if (!l_mask[i] || l_mask[i + 1] || l_mask[i + 2]) continue;
            this.tintsIndex = i + 1;
            break;
        }
        if (this.dropShadowDirection != null) {
            BasicStroke l_stroke;
            float l_outlineWidth = 1.0f;
            ColorWheelSkin l_skin = this.getSkin();
            if (l_skin == null || !(l_skin instanceof AbstractColorWheelSkin) || (l_stroke = ((AbstractColorWheelSkin)l_skin).getStroke()) instanceof BasicStroke) {
                // empty if block
            }
            this.dropShadow = DropShadowIcon.createVergeShadow(this.coverOutline, this.dropShadowDirection, this.shadowOpacity, l_outlineWidth);
        }
    }

    public Shape getCoverOutline() {
        return this.coverOutline;
    }

    protected void renderSector(Graphics g, int index) {
        Graphics2D l_g2 = (Graphics2D)g.create();
        int l_index = this.getAbsoluteSectorIndex(index);
        Color l_color = this.colorWheel.getColor(l_index);
        Arc2D l_shape = this.geometry.getInnerSector(l_index);
        String l_colorName = this.getColorName(l_index);
        Color l_fontColor = this.getContrastColor(l_index);
        l_g2.setPaint(l_color);
        l_g2.fill(l_shape);
        super.renderSector(g, index);
        TextStroke l_textStroke = new TextStroke(l_colorName, this.font, 0);
        l_shape = this.geometry.getStripeArc(l_index, this.geometry.getStripeCount() - 1, 0.5f);
        l_g2.setColor(l_fontColor);
        l_g2.setStroke(l_textStroke);
        l_g2.draw(l_shape);
        l_g2.dispose();
    }

    protected Color getContrastColor(int colorIndex) {
        return (colorIndex >= 0 && colorIndex <= 5) ^ this.colorWheel.isInverse() ? Color.black : Color.white;
    }

    protected String getColorName(int index) {
        return StringTable.get(this.colorWheel.getSpectrum().getColorName(this.colorWheel.indexInSpectrum(index)));
    }

    protected void renderColorStripe(Graphics g, Shape shape, Color color) {
        Graphics2D l_g2 = (Graphics2D)g.create();
        BasicStroke l_stroke = new BasicStroke(this.gridlineWidth);
        l_g2.setPaint(color);
        l_g2.fill(shape);
        l_g2.setColor(this.gridlineColor);
        l_g2.setStroke(l_stroke);
        l_g2.draw(shape);
        l_g2.dispose();
    }

    protected void renderCover(Graphics gr, ColorWheelSkin skin) {
        Graphics2D l_g2 = (Graphics2D)gr.create();
        int l_extend = 16;
        if (this.dropShadow != null) {
            this.dropShadow.paintIcon(null, l_g2, this.x, this.y);
        }
        l_g2.setPaint(skin.getPaint());
        l_g2.fill(this.coverOutline);
        l_g2.setColor(skin.getOutlineColor());
        l_g2.setStroke(((AbstractColorWheelSkin)skin).getStroke());
        l_g2.draw(this.coverOutline);
        Rectangle2D l_wcBounds = this.coverHole.getBounds2D();
        l_wcBounds.setFrame(l_wcBounds.getX() - (double)l_extend, l_wcBounds.getY() - (double)l_extend, l_wcBounds.getWidth() + (double)(l_extend * 2), l_wcBounds.getHeight() + (double)(l_extend * 2));
        this.renderTemperatureArcs(l_g2, l_wcBounds);
        Font l_font = this.font.deriveFont(this.font.getSize2D() * 0.85f);
        double l_angleStart = this.colorWheel.getColorScheme().getAlignmentAngle();
        l_g2.setColor(skin.getTextColor());
        for (int i = 0; i < 4; ++i) {
            TextStroke l_textStroke = new TextStroke(StringTable.get(tints[i]) + " ", l_font, 4);
            Arc2D l_shape = this.geometry.getStripeArc(this.tintsIndex, i, 0.1f, l_angleStart);
            l_g2.setStroke(l_textStroke);
            l_g2.draw(l_shape);
        }
        l_g2.dispose();
    }

    private void renderTemperatureArcs(Graphics gr, Rectangle2D bounds) {
        Graphics2D l_g2 = (Graphics2D)gr.create();
        float l_strokeWidth = 3.0f;
        float l_strokeWidth2 = 3.5f;
        float l_angleGap = 10.0f;
        ColorSpectrum l_spectrum = this.colorWheel.getSpectrum();
        float l_sectorExtent = this.colorWheel.getSectorExtent();
        float l_warmAngleStart = (float)this.colorWheel.getWarmColorsStartIndex() * l_sectorExtent + 5.0f;
        float l_warmAngleExtent = 170.0f;
        float l_coolAngleStart = (float)this.colorWheel.getCoolColorsStartIndex() * l_sectorExtent + 5.0f;
        float l_coolAngleExtent = 170.0f;
        Arc2D.Double l_warmArc = new Arc2D.Double(bounds, (double)l_warmAngleStart + this.geometry.getAngleStart(), l_warmAngleExtent, 0);
        Arc2D.Double l_coldArc = new Arc2D.Double(bounds, (double)l_coolAngleStart + this.geometry.getAngleStart(), l_coolAngleExtent, 0);
        BasicStroke l_stroke = new BasicStroke(3.0f, 1, 1);
        l_g2.setStroke(l_stroke);
        l_g2.setColor(WARM_COLOR);
        l_g2.draw(l_warmArc);
        l_g2.setColor(COOL_COLOR);
        l_g2.draw(l_coldArc);
        Rectangle2D.Double l_textBounds = new Rectangle2D.Double(bounds.getX() - 3.5, bounds.getY() - 3.5, bounds.getWidth() + 7.0, bounds.getHeight() + 7.0);
        Color l_textColor = this.skin.getTextColor();
        l_warmArc = new Arc2D.Double(l_textBounds, (double)l_warmAngleStart + this.geometry.getAngleStart() + 180.0, -180.0, 0);
        l_coldArc = new Arc2D.Double(l_textBounds, (double)l_coolAngleStart + this.geometry.getAngleStart() + 180.0, -180.0, 0);
        l_g2.setColor(l_textColor);
        Font l_font = this.font.deriveFont(this.font.getSize2D() * 0.9f);
        TextStroke l_textStroke = new TextStroke(StringTable.get(WARM_COLORS), l_font, 0);
        l_g2.setStroke(l_textStroke);
        l_g2.draw(l_warmArc);
        l_textStroke = new TextStroke(StringTable.get(COOL_COLORS), l_font, 0);
        l_g2.setStroke(l_textStroke);
        l_g2.draw(l_coldArc);
        l_g2.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.getWidth();
    }

    @Override
    public int getIconHeight() {
        return this.getHeight();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.x != x || this.y != y) {
            this.setFrame(x, y, this.width, this.height);
        }
        this.render(g);
    }
}

