/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.components;

import com.valeras.color_combine.controller.ColorTunerController;
import com.valeras.color_combine.controller.VariateColorTunerController;
import com.valeras.color_combine.controller.impl.DefaultVariateColorTunerController;
import com.valeras.color_combine.events.ColorChangeEvent;
import com.valeras.color_combine.events.ColorChangeListener;
import com.valeras.color_combine.model.VariateColorTuner;
import com.valeras.color_combine.view.VariateColorTunerView;
import com.valeras.colorwheel_harmony.ui.shapes.CustomRoundRectangle2D;
import com.valeras.colorwheel_harmony.ui.shapes.StrokeAware;
import com.valeras.colorwheel_harmony.ui.swing.AbstractNoColorPaintFactory;
import com.valeras.colorwheel_harmony.ui.swing.components.CustomShapeComponent;
import com.valeras.colorwheel_harmony.ui.swing.components.JxColorComponent;
import com.valeras.colorwheel_harmony.ui.swing.layout.GridCellLayoutManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractAction;

public class JxVariateColorTuner
extends JxColorComponent
implements CustomShapeComponent,
VariateColorTunerView {
    private static final String UI_MANAGER_COMPONENT_NAME = "colorwheel_components.VariateColorTuner.";
    public static final String UI_DEFAULTS_GRIDLINE_COLOR = "colorwheel_components.VariateColorTuner.gridline_color";
    public static final String UI_DEFAULTS_GRIDLINE_WIDTH = "colorwheel_components.VariateColorTuner.gridline_width";
    public static final String UI_DEFAULTS_OUTLINE_COLOR = "colorwheel_components.VariateColorTuner.outline_color";
    public static final String UI_DEFAULTS_OUTLINE_WIDTH = "colorwheel_components.VariateColorTuner.outline_width";
    private static final Insets DEFAULT_SAMPLE_INSETS = new Insets(0, 0, 0, 0);
    private VariateColorTunerController controller;
    private VariateColorTuner model;
    private final ColorChangeListener colorChangeListener;
    private final AbstractAction editAction;
    private int columnCount;
    private int rowCount;
    private VariateTunerLayout layout;
    private Paint noPaint;
    private int index;

    public JxVariateColorTuner(int columnCount, int rowCount, AbstractAction editAction) {
        this.installGridlineDefaults(UI_DEFAULTS_GRIDLINE_COLOR, UI_DEFAULTS_GRIDLINE_WIDTH);
        this.installOutlineDefaults(UI_DEFAULTS_OUTLINE_COLOR, UI_DEFAULTS_OUTLINE_WIDTH);
        this.noPaint = AbstractNoColorPaintFactory.createNoColorPaint();
        this.editAction = editAction;
        this.columnCount = columnCount;
        this.rowCount = rowCount;
        this.index = -1;
        Dimension l_colorCardSize = this.getPreferredColorCardSize();
        int l_chipWidth = (int)((float)l_colorCardSize.width * 2.0f / (float)columnCount);
        int l_chipHeight = (int)((float)l_colorCardSize.width * 2.0f * 0.75f / (float)rowCount);
        this.layout = new VariateTunerLayout(rowCount, columnCount, new Dimension(l_chipWidth, l_chipHeight), DEFAULT_SAMPLE_INSETS);
        this.setLayout(this.layout);
        this.setFocusable(true);
        this.model = null;
        this.controller = new DefaultVariateColorTunerController();
        this.colorChangeListener = new ColorChangeListener(){

            public void colorChanged(ColorChangeEvent event) {
                JxVariateColorTuner.this.repaint();
            }
        };
        VariateTunerMouseAdapter l_mouseAdapter = new VariateTunerMouseAdapter();
        this.addMouseMotionListener(l_mouseAdapter);
        this.addMouseListener(l_mouseAdapter);
        this.controller.addColorChangeListener(this.colorChangeListener);
    }

    public void setModel(VariateColorTuner model) {
        this.model = model;
        this.controller.setModel(model);
        this.repaint();
    }

    public VariateColorTuner getModel() {
        return this.model;
    }

    public ColorTunerController getController() {
        return this.controller;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int i;
        Shape l_shape;
        Graphics2D l_g2 = (Graphics2D)g.create();
        Shape l_outline = this.layout.getLayoutShape();
        Rectangle2D l_outlineBounds = l_outline.getBounds2D();
        BasicStroke l_outlineStroke = new BasicStroke(this.getOutlineWidth());
        BasicStroke l_gridlineStroke = new BasicStroke(this.getGridlineWidth());
        super.paintComponent(g);
        l_g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i2 = 0; i2 < this.rowCount * this.columnCount; ++i2) {
            l_shape = this.layout.getCellShape(i2);
            Paint l_paint = this.controller.getVariation(i2);
            if (l_paint == null) {
                l_paint = this.noPaint;
            }
            l_g2.setPaint(l_paint);
            l_g2.fill(l_shape);
        }
        int l_index = 4;
        l_shape = this.layout.getCellShape(4);
        Rectangle2D l_bounds = l_shape.getBounds2D();
        int l_size = (int)Math.round(l_bounds.getHeight() / 4.0);
        int l_offset = (int)((float)l_size / 8.0f);
        Point2D.Double l_cp = new Point2D.Double(l_bounds.getCenterX(), l_bounds.getCenterY());
        Point2D.Double l_pt0 = new Point2D.Double(l_offset, 0.0);
        Color l_color = this.controller.getColor();
        l_color = this.getTranslucentColor(l_color != null ? this.getContrastColor(l_color) : Color.black, 4 == this.index ? 0.75f : 0.25f);
        l_g2.setStroke(new BasicStroke());
        l_g2.setColor(l_color);
        Path2D.Double l_mark = new Path2D.Double();
        ((Path2D)l_mark).moveTo(l_bounds.getMaxX() - (double)l_offset, l_bounds.getMaxY() - (double)l_size);
        ((Path2D)l_mark).lineTo(l_bounds.getMaxX() - (double)l_offset, l_bounds.getMaxY() - (double)l_offset);
        ((Path2D)l_mark).lineTo(l_bounds.getMaxX() - (double)l_size, l_bounds.getMaxY() - (double)l_offset);
        l_mark.closePath();
        l_g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        l_g2.fill(l_mark);
        l_g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        l_g2.setColor(this.getGridlineColor());
        l_g2.setStroke(l_gridlineStroke);
        for (i = 1; i < this.columnCount; ++i) {
            int l_x = this.layout.getCellShape((int)i).getBounds().x;
            l_g2.drawLine(l_x, (int)l_outlineBounds.getMinY(), l_x, (int)l_outlineBounds.getMaxY());
        }
        for (i = 1; i < this.rowCount; ++i) {
            int l_y = this.layout.getCellShape((int)(i * this.columnCount)).getBounds().y;
            l_g2.drawLine((int)l_outlineBounds.getMinX(), l_y, (int)l_outlineBounds.getMaxX(), l_y);
        }
        l_g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        l_g2.setStroke(l_outlineStroke);
        l_g2.setColor(this.getOutlineColor());
        l_g2.draw(l_outline);
        l_g2.dispose();
    }

    @Override
    public Shape getComponentShape() {
        Rectangle l_rect = StrokeAware.createOverlayRectangle(this.layout.getLayoutShape().getBounds(), this.getOutlineWidth());
        return new RoundRectangle2D.Double(l_rect.x, l_rect.y, l_rect.width, l_rect.height, this.arcw, this.arch);
    }

    private class VariateTunerLayout
    extends GridCellLayoutManager {
        private Shape outline;
        private int arcWidth;
        private int arcHeight;

        public VariateTunerLayout(int rows, int columns, Dimension sampleSize, Insets insets) {
            super(columns, rows, sampleSize, insets, (JxVariateColorTuner.this.getOutlineWidth() - 1.0f) / 2.0f);
            this.outline = null;
            this.arcWidth = JxVariateColorTuner.this.arcw;
            this.arcHeight = JxVariateColorTuner.this.arch;
        }

        @Override
        public void layoutContainer(Container parent) {
            super.layoutContainer(parent);
            Rectangle2D l_bounds0 = this.getCellBounds(0);
            Rectangle2D l_boundsN = this.getCellBounds(this.cellCount - 1);
            this.outline = new RoundRectangle2D.Double(l_bounds0.getX(), l_bounds0.getY(), l_boundsN.getMaxX() - l_bounds0.getX() - 1.0, l_boundsN.getMaxY() - l_bounds0.getY() - 1.0, this.arcWidth, this.arcHeight);
        }

        @Override
        protected Shape createCellShape(int index, Rectangle2D bounds) {
            boolean l_ula = false;
            boolean l_ura = false;
            boolean l_bla = false;
            boolean l_bra = false;
            if (index == 0) {
                l_ula = true;
            } else if (index == this.cellCount - 1) {
                l_bra = true;
            } else if (index == this.columnCount - 1) {
                l_ura = true;
            } else if (index == this.cellCount - this.columnCount) {
                l_bla = true;
            }
            CustomRoundRectangle2D l_shape = new CustomRoundRectangle2D(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), this.arcWidth, this.arcHeight, l_ula, l_ura, l_bra, l_bla);
            return l_shape;
        }

        @Override
        public Shape getLayoutShape() {
            return this.outline;
        }
    }

    private class VariateTunerMouseAdapter
    extends MouseAdapter {
        private VariateTunerMouseAdapter() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int l_index = JxVariateColorTuner.this.layout.cellAt(e.getPoint());
            if (l_index != JxVariateColorTuner.this.index) {
                JxVariateColorTuner.this.index = l_index;
                JxVariateColorTuner.this.repaint();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JxVariateColorTuner.this.index = JxVariateColorTuner.this.layout.cellAt(e.getPoint());
            if (JxVariateColorTuner.this.index >= 0) {
                if (JxVariateColorTuner.this.index == 4) {
                    JxVariateColorTuner.this.editAction.actionPerformed(new ActionEvent(this, 1001, "edit"));
                } else {
                    JxVariateColorTuner.this.controller.setSelectedIndex(JxVariateColorTuner.this.index);
                    JxVariateColorTuner.this.controller.approve();
                }
            }
        }
    }
}

