/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.components;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import javax.swing.JLabel;

public class JxSplitColor
extends JLabel {
    public static final int SPLIT_HORIZONTAL = 1;
    public static final int SPLIT_VERTICAL = 2;
    public static final int SPLIT_DIAGONAL = 3;
    public static final int SPLIT_SQUARE = 4;
    private final int split;

    public JxSplitColor() {
        this.setOpaque(true);
        this.split = 1;
        this.installPreferredSize();
    }

    public JxSplitColor(int split) {
        this.setOpaque(true);
        this.split = split;
        this.installPreferredSize();
    }

    private void installPreferredSize() {
        this.setText("Dummy");
        int l_extent = this.getPreferredSize().height;
        this.setText(null);
        Dimension l_size = this.split == 4 ? new Dimension(l_extent * 4, l_extent * 4) : new Dimension(l_extent * 3, l_extent * 2);
        this.setPreferredSize(l_size);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D l_gr = (Graphics2D)g.create();
        Insets l_insets = this.getInsets();
        int l_width = this.getWidth() - (l_insets.left + l_insets.right);
        int l_height = this.getHeight() - (l_insets.top + l_insets.bottom);
        super.paintComponent(g);
        l_gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        l_gr.setColor(this.getForeground());
        switch (this.split) {
            case 1: {
                l_gr.fillRect(l_insets.left, l_insets.top, l_width / 2, l_height);
                break;
            }
            case 2: {
                l_gr.fillRect(l_insets.left, l_insets.top, l_width, l_height / 2);
                break;
            }
            case 3: {
                Path2D.Float l_path = new Path2D.Float();
                ((Path2D)l_path).moveTo(l_insets.left, l_insets.top);
                ((Path2D)l_path).lineTo(l_width + 1, l_height + 1);
                ((Path2D)l_path).lineTo(l_insets.left, l_height + 1);
                l_path.closePath();
                l_gr.fill(l_path);
                break;
            }
            case 4: {
                int l_extent = l_width / 4;
                l_gr.fillRect(l_insets.left + l_extent, l_insets.top + l_extent, l_width - l_extent * 2, l_height - l_extent * 2);
            }
        }
        l_gr.dispose();
    }
}

