/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.components;

import com.valeras.colorwheel_harmony.ui.swing.model.ColorCardModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class JxSimpleColorCard
extends JComponent {
    private static final String SAMPLE_TEXT = "Yy";
    private static final Insets INSETS = new Insets(0, 0, 0, 0);
    private ColorCardModel model;
    private final JLabel cHeading;
    private final JLabel cCaption;
    private final JLabel cFootnote;
    private final JColorSwatch cColorSwatch;
    private boolean headingEnabled;

    public JxSimpleColorCard() {
        this.setLayout(new GridBagLayout());
        this.headingEnabled = true;
        Dimension l_size = UIManager.getDimension("colorwheel_components.ColorCard.preferredSize");
        Dimension swatchSize = new Dimension(l_size.height, l_size.width);
        this.model = null;
        this.cHeading = new JLabel(SAMPLE_TEXT);
        this.cCaption = new JLabel(SAMPLE_TEXT);
        this.cFootnote = new JLabel(SAMPLE_TEXT);
        this.cColorSwatch = new JColorSwatch();
        this.cColorSwatch.setPreferredSize(swatchSize);
        l_size = this.cHeading.getPreferredSize();
        this.cHeading.setPreferredSize(new Dimension(swatchSize.width, l_size.height));
        l_size = this.cCaption.getPreferredSize();
        this.cCaption.setPreferredSize(new Dimension(swatchSize.width, l_size.height));
        l_size = this.cFootnote.getPreferredSize();
        this.cFootnote.setPreferredSize(new Dimension(swatchSize.width, l_size.height));
        int l_index = 0;
        this.add((Component)this.cHeading, new GridBagConstraints(0, l_index++, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0));
        this.add((Component)this.cColorSwatch, new GridBagConstraints(0, l_index++, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0));
        this.add((Component)this.cCaption, new GridBagConstraints(0, l_index++, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0));
        this.add((Component)this.cFootnote, new GridBagConstraints(0, l_index++, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0));
    }

    public boolean isColorCardHeadingEnabled() {
        return this.headingEnabled;
    }

    public void setColorCardHeadingEnabled(boolean enabled) {
        this.headingEnabled = enabled;
        this.cHeading.setVisible(this.headingEnabled);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        this.cHeading.setForeground(fg);
        this.cCaption.setForeground(fg);
        this.cFootnote.setForeground(this.dimColor(fg));
    }

    protected Color dimColor(Color color) {
        float[] l_hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float l_brightness = l_hsb[2];
        l_brightness = (float)((double)l_brightness + ((double)l_brightness > 0.5 ? -0.25 : 0.25));
        return Color.getHSBColor(l_hsb[0], l_hsb[1], l_brightness);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            Graphics l_gr = g.create();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            l_gr.dispose();
        }
        super.paintComponent(g);
    }

    protected void commit(ColorCardModel model) {
        this.cHeading.setText(model.getHeading());
        this.cCaption.setText(model.getCaption());
        this.cFootnote.setText(model.getFootnote());
        this.cColorSwatch.setBackground(model.getColor());
        this.cColorSwatch.setText(model.getText());
    }

    public void setModel(ColorCardModel model) {
        this.model = model;
        this.commit(this.model);
    }

    private class JColorSwatch
    extends JLabel {
        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D l_gr = (Graphics2D)g.create();
            Insets l_insets = this.getInsets();
            int l_x = l_insets.left;
            int l_y = l_insets.top;
            int l_width = this.getWidth() - (l_insets.left + l_insets.right);
            int l_height = this.getHeight() - (l_insets.top + l_insets.bottom);
            l_gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            l_gr.setColor(JxSimpleColorCard.this.model.getColor());
            l_gr.fillRoundRect(l_x, l_y, l_width - 1, l_height - 1, 8, 8);
            l_gr.dispose();
            super.paintComponent(g);
        }
    }
}

