/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.components;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JLabel;

public class JxRoundLabel
extends JLabel {
    private Color outlineColor = null;
    private int round = 0;
    private boolean displayAlways = false;
    private Color bg = this.getBackground();

    public JxRoundLabel() {
    }

    public JxRoundLabel(String text) {
        super(text);
    }

    public void setRound(int arc) {
        this.round = arc;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.bg = bg;
    }

    public void setOutline(Color color) {
        this.outlineColor = color;
    }

    public void setDisplayAlways(boolean flag) {
        this.displayAlways = flag;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Insets l_insets = new Insets(0, 0, 0, 0);
        String l_text = this.getText();
        if (l_text != null && l_text.trim().length() > 0 || this.displayAlways) {
            Graphics2D l_g2 = (Graphics2D)g.create();
            int l_width = this.getWidth() - (l_insets.left + l_insets.right) - 1;
            int l_height = this.getHeight() - (l_insets.top + l_insets.bottom) - 1;
            l_g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.bg != null) {
                l_g2.setColor(this.bg);
                l_g2.fillRoundRect(l_insets.left, l_insets.top, l_width, l_height, this.round, this.round);
            }
            if (this.outlineColor != null) {
                l_g2.setColor(this.outlineColor);
                l_g2.drawRoundRect(l_insets.left, l_insets.top, l_width, l_height, this.round, this.round);
            }
            l_g2.dispose();
        }
        super.paintComponent(g);
    }
}

