/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.components;

import com.valeras.colorwheel_harmony.ui.view2d.MouseAdapter2D;
import com.valeras.colorwheel_harmony.ui.view2d.Projection2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JxImageView
extends JComponent
implements ChangeListener {
    public static final int MODE_SPEED = 1;
    public static final int MODE_QUALITY = 2;
    private Projection2D projection = new Projection2D();
    private MouseAdapter2D mouseAdapter = new MouseAdapter2D(this.projection);
    private BufferedImage image;
    private int interpolationType = 1;

    public JxImageView() {
        this.projection.addChangeListener(this);
        this.mouseAdapter.setComponent(this);
        this.image = null;
        this.addComponentListener(new DefaultComponentListener());
    }

    public Projection2D getProjection() {
        return this.projection;
    }

    public void setInterpolationType(int type) {
        this.interpolationType = type;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        if (image != null) {
            Insets l_insets = this.getInsets();
            this.projection.setModelBounds(new Rectangle(0, 0, image.getWidth(), image.getHeight()));
            this.updateUserBounds(new Rectangle2D.Float(0.0f, 0.0f, this.getWidth() - (l_insets.left + l_insets.right), this.getHeight() - (l_insets.top + l_insets.bottom)));
        }
    }

    private void updateUserBounds(Rectangle2D bounds) {
        this.projection.setUserBounds(bounds);
        if (bounds == null || this.image == null) {
            return;
        }
        if (bounds.getWidth() >= (double)this.image.getWidth() && bounds.getHeight() >= (double)this.image.getHeight()) {
            this.projection.setToScale(1.0, 1.0);
            this.projection.center();
        } else {
            this.projection.zoomToFit();
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D l_g2 = (Graphics2D)g.create();
        Insets l_insets = this.getInsets();
        super.paintComponent(g);
        l_g2.setBackground(this.getBackground());
        l_g2.clearRect(0, 0, this.getWidth(), this.getHeight());
        if (this.image != null) {
            l_g2.setClip(l_insets.left, l_insets.top, this.getWidth() - (l_insets.left + l_insets.right), this.getHeight() - (l_insets.top + l_insets.bottom));
            l_g2.drawImage(this.image, new AffineTransformOp((AffineTransform)this.projection, this.interpolationType), l_insets.left, l_insets.top);
        }
        l_g2.dispose();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.repaint();
    }

    private class DefaultComponentListener
    extends ComponentAdapter {
        private DefaultComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Insets l_insets = JxImageView.this.getInsets();
            JxImageView.this.updateUserBounds(new Rectangle2D.Float(0.0f, 0.0f, JxImageView.this.getWidth() - (l_insets.left + l_insets.right), JxImageView.this.getHeight() - (l_insets.top + l_insets.bottom)));
        }
    }
}

