/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.components;

import com.valeras.color_combine.model.ColorPalette;
import com.valeras.color_combine.view.ColorPalettePreview;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.model.ColorCombineToolkit;
import com.valeras.colorwheel_harmony.ui.ColorTool;
import com.valeras.colorwheel_harmony.ui.ColorToolbarPanel;
import com.valeras.colorwheel_harmony.ui.model.ImageColorPickerModel;
import com.valeras.colorwheel_harmony.ui.shapes.StrokeAware;
import com.valeras.colorwheel_harmony.ui.swing.components.CustomShapeComponent;
import com.valeras.colorwheel_harmony.ui.swing.components.JxColorComponent;
import com.valeras.colorwheel_harmony.ui.swing.components.JxImageView;
import com.valeras.colorwheel_harmony.ui.swing.components.JxRoundLabel;
import com.valeras.colorwheel_harmony.ui.swing.panels.ColorComponentBox;
import com.valeras.colorwheel_harmony.ui.view2d.Projection2D;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JxImageColorPicker
extends JxColorComponent
implements CustomShapeComponent,
ColorPalettePreview,
ColorTool {
    private static final Insets PICKER_INSETS = new Insets(5, 0, 0, 0);
    private static final Insets RGB_INSETS = new Insets(5, 0, 0, 5);
    private static final Insets CHIP_INSETS = new Insets(5, 2, 0, 0);
    private static final Color BACKGROUND = Color.white;
    private static final Color CHIP_BACKGROUND = Color.darkGray;
    private static final Color CHIP_BORDER = Color.darkGray;
    private static final String STR_RGB = "color_picker.str.rgb";
    private static final String STR_ACTION_LOADIMAGE = "color_picker.action.load_image.str";
    private static final String STR_ACTION_ZOOMTOFIT = "color_picker.action.zoom_to_fit.str";
    private static final String STR_ACTION_ACTUALPIXELS = "color_picker.action.actual_pixels.str";
    private static final String STR_NO_IMAGE = "color_picker.msg.no_image";
    private static final String STR_PROCESSING_IMAGE = "Processing image...";
    private static final String UI_MANAGER_COMPONENT_NAME = "colorwheel_components.ColorPicker.";
    public static final String UI_DEFAULTS_GRIDLINE_COLOR = "colorwheel_components.ColorPicker.gridline_color";
    public static final String UI_DEFAULTS_GRIDLINE_WIDTH = "colorwheel_components.ColorPicker.gridline_width";
    public static final String UI_DEFAULTS_OUTLINE_COLOR = "colorwheel_components.ColorPicker.outline_color";
    public static final String UI_DEFAULTS_OUTLINE_WIDTH = "colorwheel_components.ColorPicker.outline_width";
    private ImageColorPickerModel model;
    private final JLabel filePanel;
    private final JxImageView imageView;
    private final JPanel swatchPanel;
    private final ColorComponentBox rgbComponents;
    private final JxRoundLabel pickerChip;
    private final ColorGrid sampleColors;
    private ColorCombineToolkit toolkit;
    private final ChangeListener imageChangeListener;
    private final ColorPickerMouseListener mouseListener;
    private final PropertyChangeListener modelListener;

    public JxImageColorPicker() {
        JPanel l_container = new JPanel();
        int l_extent = this.getPreferredColorChipSize();
        Dimension l_chipSize = new Dimension(l_extent, l_extent);
        this.model = new ImageColorPickerModel();
        this.toolkit = null;
        this.imageChangeListener = new DefaultImageChangeLister();
        this.mouseListener = new ColorPickerMouseListener();
        this.modelListener = new ModelPropertyChangeListener();
        this.installGridlineDefaults(UI_DEFAULTS_GRIDLINE_COLOR, UI_DEFAULTS_GRIDLINE_WIDTH);
        this.installOutlineDefaults(UI_DEFAULTS_OUTLINE_COLOR, UI_DEFAULTS_OUTLINE_WIDTH);
        this.setLayout(new BorderLayout());
        l_container.setOpaque(false);
        l_container.setLayout(new BorderLayout());
        l_container.setBorder(BorderFactory.createEmptyBorder(this.arcw, this.arch, this.arcw, this.arch));
        this.imageView = new JxImageView();
        this.imageView.setOpaque(true);
        this.imageView.setBackground(CHIP_BACKGROUND);
        this.imageView.setBorder(BorderFactory.createLineBorder(CHIP_BACKGROUND));
        this.imageView.addMouseListener(this.mouseListener);
        this.imageView.addMouseMotionListener(this.mouseListener);
        this.swatchPanel = new JPanel();
        this.swatchPanel.setLayout(new GridBagLayout());
        this.swatchPanel.setOpaque(false);
        this.pickerChip = new JxRoundLabel();
        this.pickerChip.setDisplayAlways(true);
        this.pickerChip.setPreferredSize(new Dimension(l_extent * 4, l_extent));
        this.pickerChip.setRound(this.arcw / 2);
        this.pickerChip.setOutline(CHIP_BORDER);
        this.pickerChip.setOpaque(false);
        this.pickerChip.setBackground(null);
        this.sampleColors = new ColorGrid(this.model.getSamplesCount(), l_chipSize);
        this.sampleColors.setBorder(BorderFactory.createLineBorder(Color.blue));
        this.sampleColors.setPreferredSize(new Dimension(l_chipSize.width * 5, l_chipSize.height));
        this.rgbComponents = new ColorComponentBox(StringTable.get(STR_RGB));
        this.rgbComponents.setOpaque(false);
        this.rgbComponents.setForeground(CHIP_BACKGROUND);
        this.rgbComponents.setBackground(null);
        this.swatchPanel.add((Component)this.pickerChip, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 1, PICKER_INSETS, 0, 0));
        this.swatchPanel.add((Component)this.rgbComponents, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, RGB_INSETS, 0, 0));
        this.filePanel = new JLabel(StringTable.get(STR_NO_IMAGE));
        this.filePanel.setForeground(CHIP_BACKGROUND);
        l_container.add((Component)this.filePanel, "North");
        l_container.add((Component)this.imageView, "Center");
        l_container.add((Component)this.swatchPanel, "South");
        this.add((Component)l_container, "Center");
        this.model.addPropertyChangeListener(this.modelListener);
    }

    public ImageColorPickerModel getModel() {
        return this.model;
    }

    @Override
    public Shape getComponentShape() {
        Insets l_insets = this.getInsets();
        return new RoundRectangle2D.Double(l_insets.left, l_insets.top, this.getWidth() - (l_insets.left + l_insets.right), this.getHeight() - (l_insets.top + l_insets.bottom), this.arcw, this.arch);
    }

    @Override
    public void activateTool(ColorCombineToolkit toolkit) {
        this.toolkit = toolkit;
        this.toolkit.addImageChangeListener(this.imageChangeListener);
        this.updateImage();
    }

    @Override
    public void deactivateTool() {
        if (this.toolkit != null) {
            this.toolkit.removeImageChangeListener(this.imageChangeListener);
        }
    }

    protected void updateImage() {
        Object l_source = this.toolkit.getImageSource();
        BufferedImage l_image = this.toolkit.getImage();
        this.filePanel.setText(l_source != null ? (l_source instanceof File ? ((File)l_source).getName() : l_source.toString()) : StringTable.get(STR_NO_IMAGE));
        if (l_image != null && l_image.equals(this.imageView.getImage())) {
            return;
        }
        this.imageView.setImage(l_image);
        this.imageView.repaint();
    }

    protected void updateSampleColors(Color[] colors) {
        this.sampleColors.setColors(colors);
        this.sampleColors.repaint();
    }

    public void setColorPalette(ColorPalette colorPalette) {
    }

    public void stateChanged(ChangeEvent e) {
    }

    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D l_g2 = (Graphics2D)g.create();
        Insets l_insets = this.getInsets();
        BasicStroke l_stroke = new BasicStroke(this.getOutlineWidth());
        super.paintComponent(g);
        l_g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle l_frame = StrokeAware.createStrokeAwareRectangle(this.getSize(), l_insets, this.getOutlineWidth());
        l_g2.setColor(BACKGROUND);
        l_g2.fillRoundRect(l_frame.x, l_frame.y, l_frame.width, l_frame.height, this.arcw, this.arch);
        l_g2.setStroke(l_stroke);
        l_g2.setColor(this.getOutlineColor());
        l_g2.drawRoundRect(l_frame.x, l_frame.y, l_frame.width, l_frame.height, this.arcw, this.arch);
        l_g2.dispose();
    }

    @Override
    public void putToolbarActions(ColorToolbarPanel toolbar) {
        AbstractAction l_loadImageAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JxImageColorPicker.this.model.getLoadImageAction().actionPerformed(null);
            }
        };
        AbstractAction l_zoomToFitAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JxImageColorPicker.this.imageView.getProjection().zoomToFit();
            }
        };
        AbstractAction l_actualPixelsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JxImageColorPicker.this.imageView.getProjection().reset();
            }
        };
        l_loadImageAction.putValue("Name", StringTable.get(STR_ACTION_LOADIMAGE));
        l_zoomToFitAction.putValue("Name", StringTable.get(STR_ACTION_ZOOMTOFIT));
        l_actualPixelsAction.putValue("Name", StringTable.get(STR_ACTION_ACTUALPIXELS));
        toolbar.add(l_loadImageAction);
        toolbar.add(l_zoomToFitAction);
        toolbar.add(l_actualPixelsAction);
    }

    private class ModelPropertyChangeListener
    implements PropertyChangeListener {
        private ModelPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String l_property = evt.getPropertyName();
            if (l_property.equals("color_picker_model.property.image")) {
                if (JxImageColorPicker.this.isVisible()) {
                    JxImageColorPicker.this.repaint();
                }
            } else if (l_property.equals("color_picker_model.property.sample_colors")) {
                JxImageColorPicker.this.updateSampleColors((Color[])evt.getNewValue());
            }
        }
    }

    protected class ColorSwatchPanel
    extends JPanel {
        private final int chipCount;
        private final JLabel[] colorChips;

        public ColorSwatchPanel(int samples, Dimension chipSize) {
            this.chipCount = samples;
            this.colorChips = new JLabel[this.chipCount];
            this.setLayout(new GridBagLayout());
            for (int i = 0; i < this.chipCount; ++i) {
                JLabel l_chip;
                this.colorChips[i] = l_chip = new JLabel();
                l_chip.setBorder(BorderFactory.createLineBorder(CHIP_BORDER));
                l_chip.setOpaque(true);
                l_chip.setPreferredSize(chipSize);
                this.add((Component)l_chip, new GridBagConstraints(i + 1, 0, 1, 1, 0.0, 0.0, 12, 2, CHIP_INSETS, 0, 0));
            }
        }

        public void setSwatchColor(int index, Color color) {
        }
    }

    private class ColorGrid
    extends JComponent {
        private int numColors;
        private Dimension chipSize;
        private Color[] colors;

        public ColorGrid(int numColors, Dimension chipSize) {
            this.numColors = numColors;
            this.chipSize = chipSize;
            this.colors = null;
        }

        public void setColors(Color[] colors) {
            this.colors = colors != null ? Arrays.copyOf(colors, colors.length) : null;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D l_g2 = (Graphics2D)g.create();
            int l_width = this.getWidth();
            int l_height = this.getHeight();
            super.paintComponent(g);
            BasicStroke l_outlineStroke = new BasicStroke(JxImageColorPicker.this.getOutlineWidth());
            BasicStroke l_gridlineStroke = new BasicStroke(JxImageColorPicker.this.getGridlineWidth());
            for (int i = 0; i < this.numColors; ++i) {
                Rectangle2D.Double l_shape = new Rectangle2D.Double(i * l_width / this.numColors, 0.0, l_width / this.numColors, l_height);
                if (this.colors == null || this.colors[i] == null) continue;
                l_g2.setColor(this.colors[i]);
                l_g2.fill(l_shape);
                l_g2.setColor(Color.darkGray);
                l_g2.draw(l_shape);
            }
            l_g2.dispose();
        }
    }

    private class DefaultImageChangeLister
    implements ChangeListener {
        private DefaultImageChangeLister() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JxImageColorPicker.this.updateImage();
        }
    }

    private class ColorPickerMouseListener
    extends MouseAdapter {
        private ColorPickerMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JxImageColorPicker.this.toolkit.setSelectedColor(JxImageColorPicker.this.pickerChip.getBackground());
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            BufferedImage l_image = JxImageColorPicker.this.imageView.getImage();
            Color l_color = CHIP_BACKGROUND;
            if (l_image != null) {
                Projection2D l_tx = JxImageColorPicker.this.imageView.getProjection();
                try {
                    Point2D l_pt = l_tx.inverseTransform(e.getPoint(), null);
                    int l_x = (int)l_pt.getX();
                    int l_y = (int)l_pt.getY();
                    if (l_x >= 0 && l_x < l_image.getWidth() && l_y >= 0 && l_y < l_image.getHeight()) {
                        l_color = new Color(l_image.getRGB(l_x, l_y));
                    }
                }
                catch (NoninvertibleTransformException ex) {
                    Logger.getLogger(JxImageColorPicker.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            JxImageColorPicker.this.rgbComponents.setSampleColor(l_color);
            JxImageColorPicker.this.pickerChip.setBackground(l_color);
        }
    }
}

