/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.components;

import com.valeras.colorwheel_harmony.ui.swing.components.HotSpotButtonIcon;
import com.valeras.colorwheel_harmony.ui.swing.model.PaintButtonModel;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;

public class JxHotSpotButton
extends AbstractButton {
    private final PaintButtonModel model2;
    private HotSpotButtonIcon renderer;
    private boolean focused;

    public JxHotSpotButton(PaintButtonModel model) {
        this.model2 = model;
        this.renderer = model.getRenderer();
        this.focused = false;
        DefaultMouseAdapter l_mouseAdapter = new DefaultMouseAdapter();
        this.addMouseListener(l_mouseAdapter);
        this.addMouseMotionListener(l_mouseAdapter);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.renderer.getIconWidth(), this.renderer.getIconHeight());
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(this.renderer.getIconWidth(), this.renderer.getIconHeight());
    }

    protected void setFocused(boolean flag) {
        this.focused = flag;
        this.setCursor(this.focused ? new Cursor(12) : null);
        this.repaint(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }

    public boolean isFocused() {
        return this.focused;
    }

    @Override
    protected void paintComponent(Graphics gr) {
        Graphics2D l_gr2 = (Graphics2D)gr.create();
        super.paintComponent(gr);
        this.renderer.setActive(this.focused);
        this.renderer.paintIcon(this, l_gr2, 0, 0);
        l_gr2.dispose();
    }

    private class DefaultMouseAdapter
    extends MouseAdapter {
        private DefaultMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point l_pt = e.getPoint();
            int l_index = JxHotSpotButton.this.renderer.getHotSpotRegion(l_pt.x, l_pt.y);
            if ((e.getModifiers() & 0x10) != 16) {
                return;
            }
            AbstractAction l_action = JxHotSpotButton.this.model2.getAction(l_index);
            if (l_action != null) {
                l_action.actionPerformed(null);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JxHotSpotButton.this.setFocused(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JxHotSpotButton.this.setFocused(false);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point l_pt = e.getPoint();
            int l_index = JxHotSpotButton.this.renderer.getHotSpotRegion(l_pt.x, l_pt.y);
            JxHotSpotButton.this.renderer.setActiveRegion(l_index);
            JxHotSpotButton.this.repaint();
        }
    }
}

