/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.components;

import com.valeras.color_combine.controller.ColorTunerController;
import com.valeras.color_combine.controller.impl.GrayscaleColorTunerController;
import com.valeras.color_combine.events.ColorChangeEvent;
import com.valeras.color_combine.events.ColorChangeListener;
import com.valeras.color_combine.model.GrayscaleColorTuner;
import com.valeras.color_combine.model.VariateColorTuner;
import com.valeras.color_combine.view.GrayscaleColorTunerView;
import com.valeras.colorwheel_harmony.ui.shapes.CustomRoundRectangle2D;
import com.valeras.colorwheel_harmony.ui.shapes.StrokeAware;
import com.valeras.colorwheel_harmony.ui.swing.components.CustomShapeComponent;
import com.valeras.colorwheel_harmony.ui.swing.components.JxColorComponent;
import com.valeras.colorwheel_harmony.ui.swing.icons.BasicColorCardIcon;
import com.valeras.colorwheel_harmony.ui.swing.layout.GridCellLayoutManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;

public class JxGrayscaleColorTuner
extends JxColorComponent
implements CustomShapeComponent,
GrayscaleColorTunerView {
    private static final String UI_MANAGER_COMPONENT_NAME = "colorwheel_components.GrayscaleColorTuner.";
    public static final String UI_DEFAULTS_FONT = "colorwheel_components.GrayscaleColorTuner.font";
    public static final String UI_DEFAULTS_GRIDLINE_COLOR = "colorwheel_components.GrayscaleColorTuner.gridline_color";
    public static final String UI_DEFAULTS_GRIDLINE_WIDTH = "colorwheel_components.GrayscaleColorTuner.gridline_width";
    public static final String UI_DEFAULTS_OUTLINE_COLOR = "colorwheel_components.GrayscaleColorTuner.outline_color";
    public static final String UI_DEFAULTS_OUTLINE_WIDTH = "colorwheel_components.GrayscaleColorTuner.outline_width";
    private static final Insets DEFAULT_SAMPLE_INSETS = new Insets(0, 0, 0, 0);
    protected static final String GRAYSCALE_INDEX_PROPERTY_KEY = "GRAYSCALE_INDEX";
    private static final String GRAYSCALE_FORMAT_PATTERN = "0";
    private GrayscaleColorTunerController controller;
    private GrayscaleColorTuner model;
    private final ColorChangeListener colorChangeListener;
    private GrayscaleTunerLayout layout;
    private BasicColorCardIcon[] colorCards;
    private int cellCount;
    private final DecimalFormat grayscaleFormat = new DecimalFormat("0");

    public JxGrayscaleColorTuner() {
        this.installFont(UI_DEFAULTS_FONT);
        this.installGridlineDefaults(UI_DEFAULTS_GRIDLINE_COLOR, UI_DEFAULTS_GRIDLINE_WIDTH);
        this.installOutlineDefaults(UI_DEFAULTS_OUTLINE_COLOR, UI_DEFAULTS_OUTLINE_WIDTH);
        this.colorCards = null;
        this.cellCount = 10;
        Dimension l_colorCardSize = this.getPreferredColorCardSize();
        int l_chipWidth = (int)((float)l_colorCardSize.width * 4.0f / (float)this.cellCount);
        int l_chipHeight = (int)((float)l_chipWidth / 0.75f);
        this.layout = new GrayscaleTunerLayout(1, this.cellCount, new Dimension(l_chipWidth, l_chipHeight), DEFAULT_SAMPLE_INSETS, (this.getOutlineWidth() - 1.0f) / 2.0f);
        this.setLayout(this.layout);
        this.controller = new GrayscaleColorTunerController();
        this.model = null;
        this.colorChangeListener = new ColorChangeListener(){

            public void colorChanged(ColorChangeEvent event) {
                JxGrayscaleColorTuner.this.repaint();
            }
        };
        this.controller.addColorChangeListener(this.colorChangeListener);
        this.addMouseListener(new GrayscaleTunerMouseAdapter());
    }

    public ColorTunerController getController() {
        return this.controller;
    }

    public void setModel(GrayscaleColorTuner model) {
        this.model = model;
        this.controller.setModel((VariateColorTuner)model);
        this.invalidate();
    }

    public GrayscaleColorTuner getModel() {
        return this.model;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D l_g2 = (Graphics2D)g.create();
        BasicStroke l_outlineStroke = new BasicStroke(this.getOutlineWidth());
        BasicStroke l_gridlineStroke = new BasicStroke(this.getGridlineWidth());
        super.paintComponent(g);
        l_g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = 0; i < this.cellCount; ++i) {
            BasicColorCardIcon l_colorCard = this.colorCards[i];
            Rectangle2D l_bounds = this.layout.getCellBounds(i);
            l_colorCard.paintIcon(this, l_g2, 0, 0);
        }
        l_g2.setStroke(l_outlineStroke);
        l_g2.setColor(this.getOutlineColor());
        l_g2.draw(this.layout.getLayoutShape());
        l_g2.dispose();
    }

    @Override
    public Shape getComponentShape() {
        Rectangle l_rect = StrokeAware.createOverlayRectangle(this.layout.getLayoutShape().getBounds(), this.getOutlineWidth());
        return new RoundRectangle2D.Double(l_rect.x, l_rect.y, l_rect.width, l_rect.height, this.arcw, this.arch);
    }

    static /* synthetic */ BasicColorCardIcon[] access$302(JxGrayscaleColorTuner x0, BasicColorCardIcon[] x1) {
        x0.colorCards = x1;
        return x1;
    }

    private class GrayscaleTunerLayout
    extends GridCellLayoutManager {
        private Shape outline;
        private int arcWidth;
        private int arcHeight;

        public GrayscaleTunerLayout(int rows, int columns, Dimension sampleSize, Insets insets, float gap) {
            super(rows, columns, sampleSize, insets, gap);
            this.outline = null;
            this.arcWidth = JxGrayscaleColorTuner.this.arcw;
            this.arcHeight = JxGrayscaleColorTuner.this.arch;
        }

        @Override
        public void layoutContainer(Container parent) {
            Font l_font = JxGrayscaleColorTuner.this.getFont();
            super.layoutContainer(parent);
            JxGrayscaleColorTuner.access$302(JxGrayscaleColorTuner.this, new BasicColorCardIcon[this.cellCount]);
            for (int i = 0; i < this.cellCount; ++i) {
                Rectangle2D l_cellBounds = JxGrayscaleColorTuner.this.layout.getCellBounds(i);
                BasicColorCardIcon l_colorCard = new BasicColorCardIcon((int)l_cellBounds.getWidth(), (int)l_cellBounds.getHeight(), Color.white, Color.BLACK, null, 0, 0);
                l_colorCard.setFont(l_font);
                l_colorCard.setTextRows(1);
                l_colorCard.setHorizontalTextAlignment(0);
                l_colorCard.setLabelText(JxGrayscaleColorTuner.this.grayscaleFormat.format(JxGrayscaleColorTuner.this.model.valueOf(i)));
                l_colorCard.setPaint(JxGrayscaleColorTuner.this.model.getVariation(i));
                l_colorCard.setShape(JxGrayscaleColorTuner.this.layout.getCellShape(i));
                ((JxGrayscaleColorTuner)JxGrayscaleColorTuner.this).colorCards[i] = l_colorCard;
            }
            Rectangle2D l_bounds0 = this.getCellBounds(0);
            Rectangle2D l_boundsN = this.getCellBounds(this.cellCount - 1);
            this.outline = new RoundRectangle2D.Double(l_bounds0.getX(), l_bounds0.getY(), l_boundsN.getMaxX() - l_bounds0.getX() - 1.0, l_boundsN.getMaxY() - l_bounds0.getY() - 1.0, this.arcWidth, this.arcHeight);
        }

        @Override
        protected Shape createCellShape(int index, Rectangle2D bounds) {
            boolean l_ula = false;
            boolean l_ura = false;
            boolean l_bla = false;
            boolean l_bra = false;
            if (index == 0) {
                l_ula = true;
                l_bla = true;
            } else if (index == this.cellCount - 1) {
                l_ura = true;
                l_bra = true;
            }
            CustomRoundRectangle2D l_shape = new CustomRoundRectangle2D(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), this.arcWidth, this.arcHeight, l_ula, l_ura, l_bra, l_bla);
            return l_shape;
        }

        @Override
        public Shape getLayoutShape() {
            return this.outline;
        }
    }

    private class GrayscaleTunerMouseAdapter
    extends MouseAdapter {
        private GrayscaleTunerMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int l_index = JxGrayscaleColorTuner.this.layout.cellAt(e.getPoint());
            if (l_index >= 0) {
                JxGrayscaleColorTuner.this.controller.setSelectedIndex(l_index);
                JxGrayscaleColorTuner.this.controller.approve();
            }
        }
    }
}

