/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.components;

import com.valeras.color_combine.model.ColorPalette;
import com.valeras.color_combine.view.ColorPalettePreview;
import com.valeras.colorwheel_harmony.model.ColorCombineToolkit;
import com.valeras.colorwheel_harmony.ui.ColorTool;
import com.valeras.colorwheel_harmony.ui.ColorToolbarPanel;
import com.valeras.colorwheel_harmony.ui.shapes.CustomRoundRectangle2D;
import com.valeras.colorwheel_harmony.ui.shapes.Grid;
import com.valeras.colorwheel_harmony.ui.swing.components.CustomShapeComponent;
import com.valeras.colorwheel_harmony.ui.swing.components.JxColorComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ItemEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;

public class JxContrastPattern
extends JxColorComponent
implements CustomShapeComponent,
ColorPalettePreview,
ColorTool {
    private static final String UI_MANAGER_COMPONENT_NAME = "colorwheel_components.ContrastPattern.";
    public static final String UI_DEFAULTS_GRIDLINE_COLOR = "colorwheel_components.ContrastPattern.gridline_color";
    public static final String UI_DEFAULTS_GRIDLINE_WIDTH = "colorwheel_components.ContrastPattern.gridline_width";
    public static final String UI_DEFAULTS_OUTLINE_COLOR = "colorwheel_components.ContrastPattern.outline_color";
    public static final String UI_DEFAULTS_OUTLINE_WIDTH = "colorwheel_components.ContrastPattern.outline_width";
    private ColorCombineToolkit toolkit;
    private ColorPalette colorPalette;
    private int selectedColorIndex;
    private Grid contrastGrid;

    public JxContrastPattern() {
        this.installGridlineDefaults(UI_DEFAULTS_GRIDLINE_COLOR, UI_DEFAULTS_GRIDLINE_WIDTH);
        this.installOutlineDefaults(UI_DEFAULTS_OUTLINE_COLOR, UI_DEFAULTS_OUTLINE_WIDTH);
        this.toolkit = null;
        this.colorPalette = null;
        this.selectedColorIndex = -1;
        this.contrastGrid = new Grid(3, 3);
        this.contrastGrid.setOutlineStrokeWidth(this.getOutlineWidth());
    }

    @Override
    public Shape getComponentShape() {
        Rectangle l_rect = this.contrastGrid.getBoundsOutline();
        return new RoundRectangle2D.Double(l_rect.x, l_rect.y, l_rect.width, l_rect.height, this.arcw, this.arch);
    }

    @Override
    public void activateTool(ColorCombineToolkit toolkit) {
        this.toolkit = toolkit;
        toolkit.addColorPalettePreview(this);
        this.colorPalette = toolkit.getColorPalette();
        this.selectedColorIndex = toolkit.getSelectedPaletteEntryIndex();
    }

    @Override
    public void deactivateTool() {
        this.toolkit.removeColorPalettePreview(this);
    }

    public void setColorPalette(ColorPalette colorPalette) {
        this.colorPalette = colorPalette;
    }

    public void stateChanged(ChangeEvent e) {
        this.selectedColorIndex = this.toolkit.getSelectedPaletteEntryIndex();
        this.repaint();
    }

    public void itemStateChanged(ItemEvent e) {
        this.selectedColorIndex = this.toolkit.getSelectedPaletteEntryIndex();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D l_g2 = (Graphics2D)g.create();
        Insets l_insets = this.getInsets();
        Color[] l_colors = this.colorPalette != null ? this.colorPalette.getColors() : null;
        int l_width = this.getWidth() - (l_insets.left + l_insets.right);
        int l_height = this.getHeight() - (l_insets.top + l_insets.bottom);
        this.contrastGrid.setInsets(l_insets);
        this.contrastGrid.setSize(this.getWidth(), this.getHeight());
        ContrastIcon l_icon = new ContrastIcon(l_width, l_height, this.contrastGrid, l_colors, this.selectedColorIndex);
        super.paintComponent(g);
        l_icon.paintIcon(this, g, 0, 0);
        BasicStroke l_stroke = new BasicStroke(this.getOutlineWidth());
        l_g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        l_g2.setStroke(l_stroke);
        l_g2.setColor(this.getOutlineColor());
        Rectangle l_frame = this.contrastGrid.getBounds();
        l_g2.drawRoundRect(l_frame.x, l_frame.y, l_frame.width, l_frame.height, this.arcw, this.arch);
        l_g2.dispose();
    }

    @Override
    public void putToolbarActions(ColorToolbarPanel toolbar) {
    }

    private class ContrastIcon
    implements Icon {
        private static final int ROW_COUNT = 2;
        private static final int COL_COUNT = 4;
        private final int width;
        private final int height;
        private final int inset;
        private final int extent;
        private final Dimension swatchSize;
        private final Color[] colors;
        private final int selectedColor;
        private final Grid contrastGrid;

        public ContrastIcon(int width, int height, Grid contrastGrid, Color[] colors, int selected) {
            this.width = width;
            this.height = height;
            this.contrastGrid = contrastGrid;
            int gap = 0;
            this.colors = colors;
            this.selectedColor = selected;
            this.inset = width / 16;
            this.extent = (width - gap * 2 - this.inset * 5) / 6;
            this.swatchSize = new Dimension((width - gap * 2 - this.extent - this.inset * 5) / 4, (height - gap * 2 - this.extent - this.inset * 3) / 2);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        private Shape customizeRect(Rectangle rect, int tx, int ty, boolean ul, boolean ur, boolean br, boolean bl) {
            rect.translate(tx, ty);
            return new CustomRoundRectangle2D(rect.x, rect.y, rect.width, rect.height, JxContrastPattern.this.arcw, JxContrastPattern.this.arch, ul, ur, br, bl);
        }

        private Rectangle translateRect(Rectangle rect, int tx, int ty) {
            rect.translate(tx, ty);
            return rect;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D l_gr2 = (Graphics2D)g.create();
            int l_x = x;
            int l_y = y;
            l_gr2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            l_gr2.setColor(Color.white);
            l_gr2.fill(this.customizeRect(this.contrastGrid.getCellBounds(0), x, y, true, false, false, false));
            l_gr2.fill(this.customizeRect(this.contrastGrid.getCellBounds(8), x, y, false, false, true, false));
            l_gr2.setColor(Color.black);
            l_gr2.fill(this.customizeRect(this.contrastGrid.getCellBounds(2), x, y, false, true, false, false));
            l_gr2.fill(this.customizeRect(this.contrastGrid.getCellBounds(6), x, y, false, false, false, true));
            l_gr2.setColor(Color.gray);
            l_gr2.fill(this.translateRect(this.contrastGrid.getCellBounds(1), x, y));
            l_gr2.fill(this.translateRect(this.contrastGrid.getCellBounds(3), x, y));
            l_gr2.fill(this.translateRect(this.contrastGrid.getCellBounds(5), x, y));
            l_gr2.fill(this.translateRect(this.contrastGrid.getCellBounds(7), x, y));
            if (this.colors != null) {
                Color l_color;
                Color color = l_color = this.selectedColor < this.colors.length ? this.colors[this.selectedColor] : null;
                if (l_color != null) {
                    l_gr2.setColor(l_color);
                    l_gr2.fillRoundRect(l_x + this.extent / 2, l_y + this.extent / 2, this.width - this.extent, this.height - this.extent, JxContrastPattern.this.arcw, JxContrastPattern.this.arch);
                    for (int row = 0; row < 2; ++row) {
                        for (int col = 0; col < 4; ++col) {
                            int l_index = row * 4 + col;
                            Rectangle l_rect = new Rectangle(l_x + this.extent / 2 + col * (this.swatchSize.width + this.inset) + this.inset, l_y + this.extent / 2 + row * (this.swatchSize.height + this.inset) + this.inset, this.swatchSize.width, this.swatchSize.height);
                            Color color2 = l_color = l_index < this.colors.length ? this.colors[l_index] : null;
                            if (l_color == null) continue;
                            if (l_index != this.selectedColor) {
                                l_gr2.setColor(l_color);
                                l_gr2.fill(l_rect);
                                continue;
                            }
                            l_gr2.setColor(Color.gray);
                            l_gr2.draw(l_rect);
                            l_gr2.setColor(Color.white);
                            l_gr2.draw(new Rectangle2D.Double(l_rect.getMinX(), l_rect.getMinY(), l_rect.getWidth() / 2.0, l_rect.getHeight() / 2.0));
                            l_gr2.setColor(Color.black);
                            l_gr2.draw(new Rectangle2D.Double(l_rect.getCenterX(), l_rect.getCenterY(), l_rect.getWidth() / 2.0, l_rect.getHeight() / 2.0));
                        }
                    }
                }
            }
            l_gr2.dispose();
        }
    }
}

