/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.components;

import com.valeras.color_combine.controller.ColorWheelController;
import com.valeras.color_combine.controller.SampleColorProducerController;
import com.valeras.color_combine.controller.impl.DefaultColorWheelController;
import com.valeras.color_combine.model.ColorWheel;
import com.valeras.color_combine.view.ColorWheelView;
import com.valeras.color_combine.view.geometry.Pie2D;
import com.valeras.colorwheel_harmony.model.ColorCombineToolkit;
import com.valeras.colorwheel_harmony.ui.ColorTool;
import com.valeras.colorwheel_harmony.ui.ColorToolbarPanel;
import com.valeras.colorwheel_harmony.ui.swing.components.CustomShapeComponent;
import com.valeras.colorwheel_harmony.ui.swing.components.JxColorComponent;
import com.valeras.colorwheel_harmony.ui.swing.components.colorwheel_renderer.AbstractColorWheelSkin;
import com.valeras.colorwheel_harmony.ui.swing.components.colorwheel_renderer.ColorWheelSwingRenderer;
import com.valeras.colorwheel_harmony.ui.swing.icons.ColorPieIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JxColorWheel
extends JxColorComponent
implements CustomShapeComponent,
ColorWheelView,
ColorTool {
    private static final String UI_MANAGER_COMPONENT_NAME = "colorwheel_components.JxColorWheel.";
    public static final String UI_DEFAULTS_FONT = "colorwheel_components.JxColorWheel.font";
    public static final String UI_DEFAULTS_GRIDLINE_COLOR = "colorwheel_components.JxColorWheel.gridline_color";
    public static final String UI_DEFAULTS_GRIDLINE_WIDTH = "colorwheel_components.JxColorWheel.gridline_width";
    public static final String UI_DEFAULTS_OUTLINE_COLOR = "colorwheel_components.JxColorWheel.outline_color";
    public static final String UI_DEFAULTS_OUTLINE_WIDTH = "colorwheel_components.JxColorWheel.outline_width";
    public static final String UI_DEFAULTS_SELECT_ICON = "colorwheel_components.JxColorWheel.select_icon";
    private static final Dimension MINIMUM_SIZE = new Dimension(64, 64);
    private ColorWheelController controller;
    private ColorWheel model;
    private final ColorWheelSwingRenderer renderer;
    private Shape customShape;
    private final DefaultRotateChangeListener defaultRotateChangeListener;
    private final ColorWheelControllerChangeListener defaultControllerChangeListener;
    private AbstractColorWheelSkin skin;
    private boolean selectedColorVisible;
    private Color selectedColor;
    private boolean sampleColorsVisible;
    private final Map<Point, ColorPieIcon> sampleColorIcons;
    private Icon selectIcon;

    public JxColorWheel(AbstractColorWheelSkin skin, Point2D dropShadowDirection, float shadowOpacity) {
        this.setLayout(new ColorWheelLayout());
        this.setFocusable(true);
        this.installFont(UI_DEFAULTS_FONT);
        this.installGridlineDefaults(UI_DEFAULTS_GRIDLINE_COLOR, UI_DEFAULTS_GRIDLINE_WIDTH);
        this.installOutlineDefaults(UI_DEFAULTS_OUTLINE_COLOR, UI_DEFAULTS_OUTLINE_WIDTH);
        this.selectIcon = UIManager.getIcon(UI_DEFAULTS_SELECT_ICON);
        this.sampleColorIcons = new HashMap<Point, ColorPieIcon>();
        this.selectedColorVisible = false;
        this.sampleColorsVisible = false;
        this.selectedColor = null;
        this.skin = skin;
        this.renderer = new ColorWheelSwingRenderer(JxColorWheel.MINIMUM_SIZE.width, JxColorWheel.MINIMUM_SIZE.height, skin, this.getFont(), dropShadowDirection, shadowOpacity);
        this.renderer.setGridlineColor(this.getGridlineColor());
        this.renderer.setGridlineWidth(this.getGridlineWidth());
        this.customShape = null;
        this.controller = new DefaultColorWheelController();
        this.defaultRotateChangeListener = new DefaultRotateChangeListener();
        this.defaultControllerChangeListener = new ColorWheelControllerChangeListener();
        this.controller.addRotateChangeListener((ChangeListener)this.defaultRotateChangeListener);
        this.controller.addChangeListener((ChangeListener)this.defaultControllerChangeListener);
        CWMouseListener l_ml = new CWMouseListener();
        this.addMouseListener(l_ml);
        this.addMouseMotionListener(l_ml);
        this.addMouseWheelListener(l_ml);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
    }

    @Override
    public Color getBackground() {
        return super.getBackground();
    }

    public SampleColorProducerController getController() {
        return this.controller;
    }

    public void setModel(ColorWheel model) {
        this.model = model;
        this.renderer.setColorWheel(this.model);
        this.controller.setModel(model);
        this.invalidate();
        this.repaint();
    }

    public ColorWheel getModel() {
        return this.model;
    }

    public void setColorWheelSkin(AbstractColorWheelSkin skin) {
        this.skin = skin;
        this.renderer.setSkin(skin);
        this.invalidate();
        this.repaint();
    }

    public void setSelectedColorVisible(boolean enabled) {
        this.selectedColorVisible = enabled;
        this.repaint();
    }

    public boolean isSelectedColorVisible() {
        return this.selectedColorVisible;
    }

    public void setSelectedColor(Color color) {
        this.selectedColor = color;
        this.repaint();
    }

    public void setSampleColorsVisible(boolean enabled) {
        this.sampleColorsVisible = enabled;
        this.repaint();
    }

    public boolean isSampleColorsVisible() {
        return this.sampleColorsVisible;
    }

    public void setSampleColors(Color[] colors) {
        ArrayList l_colors;
        HashMap<Point, ArrayList> l_labels = new HashMap<Point, ArrayList>();
        this.sampleColorIcons.clear();
        if (colors == null) {
            return;
        }
        int l_iconWidth = this.selectIcon.getIconWidth();
        int l_iconHeight = this.selectIcon.getIconHeight();
        for (Color c : colors) {
            if (c == null || JxColorWheel.isGrayscale(c)) continue;
            Point l_pos = this.model.pointOf(c);
            if (l_labels.containsKey(l_pos)) {
                l_colors = (ArrayList)l_labels.get(l_pos);
            } else {
                l_colors = new ArrayList();
                l_labels.put(l_pos, l_colors);
            }
            l_colors.add(c);
        }
        Set l_points = l_labels.keySet();
        for (Point p : l_points) {
            l_colors = (ArrayList)l_labels.get(p);
            ColorPieIcon l_icon = new ColorPieIcon(l_iconWidth, l_iconHeight, l_colors.toArray(new Color[l_colors.size()]), this.getOutlineColor(), new BasicStroke(this.getGridlineWidth()));
            this.sampleColorIcons.put(p, l_icon);
        }
        this.repaint();
    }

    @Override
    public void activateTool(ColorCombineToolkit toolkit) {
    }

    @Override
    public void deactivateTool() {
    }

    @Override
    public void putToolbarActions(ColorToolbarPanel toolbar) {
    }

    @Override
    public Shape getComponentShape() {
        return this.customShape;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Point2D l_pnt;
        Graphics2D l_g = (Graphics2D)g.create();
        if (this.model == null) {
            return;
        }
        l_g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.renderer.setRotate(this.controller.getRotate());
        this.renderer.render(l_g);
        if (this.sampleColorsVisible) {
            Set<Point> l_pnts = this.sampleColorIcons.keySet();
            for (Point p : l_pnts) {
                ColorPieIcon l_icon = this.sampleColorIcons.get(p);
                l_pnt = this.renderer.getGeometry().getStripeCP(p.x, p.y);
                l_icon.paintIcon(this, l_g, (int)l_pnt.getX() - l_icon.getIconWidth() / 2, (int)l_pnt.getY() - l_icon.getIconHeight() / 2);
            }
        }
        if (this.selectedColorVisible && this.selectedColor != null && !JxColorWheel.isGrayscale(this.selectedColor)) {
            Point l_colorPos = this.model.pointOf(this.selectedColor);
            l_pnt = this.renderer.getGeometry().getStripeCP(l_colorPos.x, l_colorPos.y);
            this.selectIcon.paintIcon(this, l_g, (int)l_pnt.getX() - this.selectIcon.getIconWidth() / 2, (int)l_pnt.getY() - this.selectIcon.getIconHeight() / 2);
        }
        l_g.dispose();
    }

    protected static boolean isGrayscale(Color c) {
        int g = c.getGreen();
        return c.getRed() == g && g == c.getBlue();
    }

    private class ColorWheelControllerChangeListener
    implements ChangeListener {
        private ColorWheelControllerChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JxColorWheel.this.renderer.setInvalidated(true);
            JxColorWheel.this.invalidate();
            JxColorWheel.this.repaint();
        }
    }

    private class CWMouseListener
    extends MouseAdapter {
        private Float recentAngle = null;
        private float sumAngle = 0.0f;

        @Override
        public void mouseClicked(MouseEvent e) {
            Pie2D l_geometry = JxColorWheel.this.renderer.getGeometry();
            Point l_point = new Point(e.getX(), e.getY());
            int l_sectorIndex = l_geometry.sectorAt((Point2D)l_point);
            int l_stripeIndex = l_geometry.stripeAt((Point2D)l_point);
            if (l_sectorIndex >= 0 && JxColorWheel.this.model.isSectorEnabled(l_sectorIndex) && l_stripeIndex >= 0) {
                JxColorWheel.this.controller.sample(l_sectorIndex, l_stripeIndex);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point l_pos = this.getRelativePosition(e.getX(), e.getY());
            this.recentAngle = Float.valueOf(this.getAngle(l_pos.x, l_pos.y));
            this.sumAngle = 0.0f;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.recentAngle = null;
            JxColorWheel.this.controller.rectify(this.sumAngle >= 0.0f ? 1 : -1);
            this.sumAngle = 0.0f;
        }

        private Point getRelativePosition(int x, int y) {
            Pie2D l_geometry = JxColorWheel.this.renderer.getGeometry();
            int l_cx = (int)l_geometry.getCenterX();
            int l_cy = (int)l_geometry.getCenterY();
            return new Point(x -= l_cx, -(y -= l_cy));
        }

        private float getAngle(int x, int y) {
            float l_angle = 0.0f;
            if ((float)y == 0.0f) {
                l_angle = x >= 0 ? 0.0f : 180.0f;
                return l_angle;
            }
            l_angle = (float)Math.toDegrees(Math.atan(Math.abs((double)x / (double)y)));
            if (x >= 0 && y >= 0) {
                l_angle = 90.0f - l_angle;
            } else if (x < 0 && y >= 0) {
                l_angle += 90.0f;
            } else if (x < 0 && y < 0) {
                l_angle = 270.0f - l_angle;
            } else if (x >= 0 && y < 0) {
                l_angle += 270.0f;
            }
            return l_angle;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point l_pos = this.getRelativePosition(e.getX(), e.getY());
            float l_angle = this.getAngle(l_pos.x, l_pos.y);
            if (this.recentAngle == null) {
                this.recentAngle = Float.valueOf(l_angle);
                return;
            }
            float l_theta = l_angle - this.recentAngle.floatValue();
            this.recentAngle = Float.valueOf(l_angle);
            this.sumAngle += l_theta;
            JxColorWheel.this.controller.rotate(l_theta);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int l_turns = -e.getWheelRotation();
            JxColorWheel.this.controller.turn(l_turns);
        }
    }

    private class DefaultRotateChangeListener
    implements ChangeListener {
        private DefaultRotateChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JxColorWheel.this.repaint();
        }
    }

    protected class CWKeyListener
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 37) {
                JxColorWheel.this.controller.turn(1);
            } else if (keyCode == 39) {
                JxColorWheel.this.controller.turn(-1);
            }
        }
    }

    private class ColorWheelLayout
    implements LayoutManager {
        private ColorWheelLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int l_height;
            int MIN_VARIATION_COUNT = 4;
            int l_defaultExtent = JxColorWheel.this.getPreferredColorChipSize();
            Insets l_insets = JxColorWheel.this.getInsets();
            int l_variationCount = JxColorWheel.this.model != null ? JxColorWheel.this.model.getVariationCount() : 4;
            int l_stripeCount = (l_variationCount + 2) * 2;
            int l_width = l_height = l_stripeCount * l_defaultExtent;
            return new Dimension(l_width += l_insets.left + l_insets.right, l_height += l_insets.top + l_insets.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            int l_height;
            int l_size;
            int l_dy;
            Insets l_insets = JxColorWheel.this.getInsets();
            if (JxColorWheel.this.model == null) {
                JxColorWheel.this.customShape = null;
                return;
            }
            float l_outlineWidth = JxColorWheel.this.skin.getStroke().getLineWidth();
            int l_dx = l_dy = (int)(l_outlineWidth / 2.0f);
            int l_dw = (int)l_outlineWidth;
            int l_width = JxColorWheel.this.getWidth() - l_insets.left - l_insets.right - l_dw - (int)JxColorWheel.this.shadowDirection.getX();
            if (l_width > (l_size = Math.min(l_width, l_height = JxColorWheel.this.getHeight() - l_insets.top - l_insets.bottom - l_dw - (int)JxColorWheel.this.shadowDirection.getY()))) {
                l_dx += (l_width - l_size) / 2;
            }
            if (l_height > l_size) {
                l_dy += (l_height - l_size) / 2;
            }
            JxColorWheel.this.renderer.setFrame(l_insets.left + l_dx, l_insets.top + l_dy, l_size, l_size);
            JxColorWheel.this.customShape = JxColorWheel.this.renderer.getCoverOutline();
        }
    }
}

