/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.components;

import com.valeras.color_combine.controller.ColorPaletteController;
import com.valeras.color_combine.controller.impl.DefaultColorPaletteController;
import com.valeras.color_combine.model.ColorPalette;
import com.valeras.color_combine.view.ColorPaletteView;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.model.ColorDetails;
import com.valeras.colorwheel_harmony.ui.shapes.StrokeAware;
import com.valeras.colorwheel_harmony.ui.swing.AbstractNoColorPaintFactory;
import com.valeras.colorwheel_harmony.ui.swing.components.JxColorComponent;
import com.valeras.colorwheel_harmony.ui.swing.icons.BasicColorCardIcon;
import com.valeras.colorwheel_harmony.ui.swing.layout.CellLayoutManager;
import com.valeras.effects2d.DropShadowIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JxColorPalette
extends JxColorComponent
implements ColorPaletteView {
    public static final String UI_MANAGER_COMPONENT_NAME = "colorwheel_components.ColorPalette.";
    public static final String UI_DEFAULTS_FONT = "colorwheel_components.ColorPalette.font";
    public static final String UI_DEFAULTS_SELECT_ICON = "colorwheel_components.ColorPalette.select_icon";
    public static final String UI_DEFAULTS_OUTLINE_COLOR = "colorwheel_components.ColorPalette.outline_color";
    public static final String UI_DEFAULTS_OUTLINE_WIDTH = "colorwheel_components.ColorPalette.outline_width";
    public static final String UI_GRIDLINECOLOR_KEY = "colorwheel_components.ColorPalette.gridline_color";
    public static final String UI_GRIDLINEWIDTH_KEY = "colorwheel_components.ColorPalette.gridline_width";
    private static final String STR_SRGB = "CS_sRGB";
    private static final String STR_NONE = "message.none";
    private ColorPaletteController controller;
    private ColorPalette colorPalette;
    private CellLayoutManager layoutManager;
    private final ChangeListener changeListener;
    private final ItemListener itemListener;
    private final MouseAdapter mouseAdapter;
    private BasicColorCardIcon colorCardIcon;
    private DropShadowIcon[] dropShadowIcons;
    private AbstractAction colorPropertiesAction;

    public JxColorPalette(CellLayoutManager layoutManager) {
        HashMap<RenderingHints.Key, Object> l_renderingHints = new HashMap<RenderingHints.Key, Object>();
        l_renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.layoutManager = layoutManager;
        super.setLayout(this.layoutManager);
        this.installFont(UI_DEFAULTS_FONT);
        this.installOutlineDefaults(UI_DEFAULTS_OUTLINE_COLOR, UI_DEFAULTS_OUTLINE_WIDTH);
        Icon l_selectIcon = UIManager.getIcon(UI_DEFAULTS_SELECT_ICON);
        this.colorPropertiesAction = null;
        this.colorPalette = null;
        this.controller = new DefaultColorPaletteController();
        this.dropShadowIcons = null;
        this.colorCardIcon = new BasicColorCardIcon(16, 16, Color.white, Color.BLACK, this.getOutlineColor(), this.arcw, this.arch);
        this.colorCardIcon.setTextRows(2);
        this.colorCardIcon.setSelectIcon(l_selectIcon);
        this.colorCardIcon.setStroke(new BasicStroke(this.getOutlineWidth()));
        this.colorCardIcon.setNoPaint(AbstractNoColorPaintFactory.createNoColorPaint());
        this.colorCardIcon.setRenderingHints(l_renderingHints);
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JxColorPalette.this.repaint();
            }
        };
        this.itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JxColorPalette.this.repaint();
            }
        };
        this.controller.addChangeListener(this.changeListener);
        this.controller.addItemListener(this.itemListener);
        this.mouseAdapter = new ColorPaletteMouseAdapter();
        this.addMouseListener(this.mouseAdapter);
        this.addMouseWheelListener(this.mouseAdapter);
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        this.layoutManager = (CellLayoutManager)mgr;
        super.setLayout(this.layoutManager);
        this.controller.setSelectedIndex(0);
        this.dropShadowIcons = null;
        this.validate();
    }

    public void setModel(ColorPalette model) {
        this.colorPalette = model;
        this.controller.setModel(this.colorPalette);
    }

    public ColorPalette getModel() {
        return this.colorPalette;
    }

    public ColorPaletteController getController() {
        return this.controller;
    }

    protected void setController(ColorPaletteController controller) {
        if (this.controller != null) {
            this.controller.removeChangeListener(this.changeListener);
            this.controller.removeItemListener(this.itemListener);
        }
        this.controller = controller;
        if (this.controller != null) {
            this.controller.addChangeListener(this.changeListener);
            this.controller.addItemListener(this.itemListener);
        }
    }

    public void setColorPropertiesAction(AbstractAction action) {
        this.colorPropertiesAction = action;
    }

    private void createDropShadow() {
        CellLayoutManager l_layout = (CellLayoutManager)this.getLayout();
        int l_count = l_layout.getCellCount();
        this.dropShadowIcons = new DropShadowIcon[l_count];
        if (l_layout.isEqualShapes()) {
            Rectangle2D l_bounds = l_layout.getCellBounds(0);
            this.colorCardIcon.setSize(new Dimension((int)l_bounds.getWidth(), (int)l_bounds.getHeight()));
            Rectangle l_rect = StrokeAware.createOverlayRectangle(this.colorCardIcon.getShape(0, 0).getBounds(), this.getOutlineWidth());
            DropShadowIcon l_icon = DropShadowIcon.createDropShadow(new RoundRectangle2D.Double(l_rect.x, l_rect.y, l_rect.width, l_rect.height, this.arcw, this.arch), this.shadowDirection, this.shadowOpacity);
            for (int i = 0; i < l_count; ++i) {
                this.dropShadowIcons[i] = l_icon;
            }
        } else {
            for (int i = 0; i < l_count; ++i) {
                DropShadowIcon l_icon;
                Rectangle2D l_bounds = l_layout.getCellBounds(i);
                this.colorCardIcon.setSize(new Dimension((int)l_bounds.getWidth(), (int)l_bounds.getHeight()));
                Rectangle l_rect = StrokeAware.createOverlayRectangle(this.colorCardIcon.getShape(0, 0).getBounds(), this.getOutlineWidth());
                this.dropShadowIcons[i] = l_icon = DropShadowIcon.createDropShadow(new RoundRectangle2D.Double(l_rect.x, l_rect.y, l_rect.width, l_rect.height, this.arcw, this.arch), this.shadowDirection, this.shadowOpacity);
            }
        }
    }

    @Override
    protected void printBorder(Graphics g) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        ColorPalette l_palette = this.controller.getModel();
        if (this.dropShadowIcons == null) {
            this.createDropShadow();
        }
        super.paintComponent(g);
        for (int i = 0; i < this.layoutManager.getCellCount(); ++i) {
            Rectangle2D l_bounds = this.layoutManager.getCellBounds(i);
            DropShadowIcon l_shadow = this.dropShadowIcons[i];
            Color l_color = l_palette.size() > i ? (Color)l_palette.get(i) : null;
            int l_x = (int)l_bounds.getX();
            int l_y = (int)l_bounds.getY();
            l_shadow.paintIcon(this, g, l_x, l_y);
            this.colorCardIcon.setCommentText(this.colorPalette.getLabel(i));
            this.colorCardIcon.setSize(new Dimension((int)l_bounds.getWidth(), (int)l_bounds.getHeight()));
            this.colorCardIcon.paintIcon(this, g, l_x, l_y, l_color, this.getColorCardCaption(l_color), i == this.controller.getSelectedIndex() && !this.isPaintingForPrint());
        }
    }

    private String getColorCardCaption(Color color) {
        ColorDetails l_details = null;
        String l_text = StringTable.get(STR_NONE);
        if (color != null) {
            l_details = ColorDetails.getDetails(color);
            String l_cs = l_details.isColorChartEntry() ? l_details.getColorChartEntry().getColorChart().getDisplayName() : StringTable.get(STR_SRGB);
            String l_value = l_details.getCode();
            if (l_value == null) {
                l_value = l_details.getValue();
            }
            String l_name = l_details.getDisplayName();
            l_text = (l_value != null ? l_value + " | " : "") + l_cs + "\n" + (l_name != null ? l_name : "");
        }
        return l_text;
    }

    private class ColorPaletteMouseAdapter
    extends MouseAdapter {
        private ColorPaletteMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int l_index = -1;
            l_index = JxColorPalette.this.layoutManager.cellAt(e.getPoint());
            if (l_index >= 0 && l_index < JxColorPalette.this.controller.getModel().size()) {
                JxColorPalette.this.controller.setSelectedIndex(l_index);
                if (e.getClickCount() == 2 && JxColorPalette.this.colorPropertiesAction != null) {
                    JxColorPalette.this.colorPropertiesAction.actionPerformed(null);
                }
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int l_count = JxColorPalette.this.layoutManager.getCellCount();
            int l_size = JxColorPalette.this.controller.getModel().size();
            int l_index = JxColorPalette.this.controller.getSelectedIndex() + e.getWheelRotation();
            if (l_index < 0) {
                l_index = Math.min(l_count, l_size) - 1;
            }
            if (l_index >= l_count || l_index >= l_size) {
                l_index = 0;
            }
            JxColorPalette.this.controller.setSelectedIndex(l_index);
        }
    }
}

