/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.components;

import com.valeras.color_chart.ColorChart;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.model.ColorDetails;
import com.valeras.colorwheel_harmony.ui.model.ColorMatchingModel;
import com.valeras.colorwheel_harmony.ui.swing.components.JxColorCard;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JxColorMatching
extends JxColorCard {
    private static final String UI_MANAGER_COMPONENT_NAME = "colorwheel_components.MatchColorTuner.";
    public static final String UI_DEFAULTS_OUTLINE_COLOR = "colorwheel_components.MatchColorTuner.outline_color";
    public static final String UI_DEFAULTS_OUTLINE_WIDTH = "colorwheel_components.MatchColorTuner.outline_width";
    private static final String STR_NOT_AVAILABLE = "component.match_tuner.not_available";
    private static final String STR_CLICK_APPROVE = "component.match_tuner.approve";
    private static final String STR_MATCH_TO_CAPTION = "component.match_tuner.str.match_to_caption";
    private static final String STR_ALREADY_MATCHED_CAPTION = "component.match_tuner.str.already_matched_caption";
    private static final String STR_NO_COLOR = "component.match_tuner.no_color";
    private static final String STR_NO_COLOR_CHART = "component.match_tuner.none_selected";
    private static final String STR_SRGB = "CS_sRGB";
    private static final String STR_DELTA = "cie1976_delta";
    protected ColorMatchingModel model;
    private ColorChangeListener colorChangeListener;
    private final NumberFormat deltaFormat;

    public JxColorMatching() {
        super(1, 2);
        this.installOutlineDefaults(UI_DEFAULTS_OUTLINE_COLOR, UI_DEFAULTS_OUTLINE_WIDTH);
        this.model = null;
        this.deltaFormat = NumberFormat.getNumberInstance(Locale.US);
        this.deltaFormat.setMinimumFractionDigits(1);
        this.deltaFormat.setMaximumFractionDigits(1);
        this.colorChangeListener = new ColorChangeListener();
        this.addMouseListener(new DefaultMouseListener());
    }

    public void setModel(ColorMatchingModel model) {
        this.model = model;
        model.addChangeListener(this.colorChangeListener);
    }

    public ColorMatchingModel getModel() {
        return this.model;
    }

    @Override
    protected Dimension getPreferredLayoutSize() {
        int l_width = this.getPreferredColorCardSize().width * 2;
        return new Dimension(l_width, (int)((float)l_width * 0.75f));
    }

    protected void updateCaption() {
        ColorDetails l_details;
        String l_text = StringTable.get(STR_NOT_AVAILABLE);
        ColorSpace l_cs = this.model.getCMS().getColorSpace();
        Color l_sampleColor = this.model.getColor();
        Color l_referenceColor = this.model.getOriginalColor();
        boolean l_armed = l_referenceColor != null && l_cs != null && !l_referenceColor.getColorSpace().equals(l_cs);
        ColorDetails colorDetails = l_details = l_sampleColor != null ? ColorDetails.getDetails(l_sampleColor) : null;
        String l_caption = l_cs != null ? (l_cs instanceof ColorChart ? ((ColorChart)l_cs).getDisplayName() : l_cs.toString()) : StringTable.get(STR_NO_COLOR_CHART);
        String l_description = l_sampleColor != null ? (l_details != null ? l_details.getDetailedName() : StringTable.get(STR_NOT_AVAILABLE)) : StringTable.get(STR_NO_COLOR);
        l_text = MessageFormat.format(StringTable.get(l_armed ? STR_MATCH_TO_CAPTION : STR_ALREADY_MATCHED_CAPTION), l_caption, l_description);
        this.setColor(l_sampleColor);
        this.setSecondaryColor(l_referenceColor);
        this.setCaptionText(l_text);
        this.setCommentText(l_armed ? StringTable.get(STR_CLICK_APPROVE) : "");
        l_text = this.model.getCMS().isArmed() ? "<html>" + MessageFormat.format(StringTable.get(STR_DELTA) + "={0}", this.deltaFormat.format(this.model.getColorDifference())) + "</html>" : null;
        this.setToolTipText(l_text);
    }

    private class ColorChangeListener
    implements ChangeListener {
        private ColorChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JxColorMatching.this.updateCaption();
            JxColorMatching.this.repaint();
        }
    }

    private class DefaultMouseListener
    extends MouseAdapter {
        private DefaultMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JxColorMatching.this.model.getCMS().approve();
        }
    }
}

