/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.UIManager;

public abstract class JxColorComponent
extends JComponent {
    private static final String UI_MANAGER_COMPONENT_NAME = "colorwheel_components.JxColorComponent.";
    public static final String UI_DEFAULTS_COLOR_CARD_SIZE = "colorwheel_components.JxColorComponent.color_card_size";
    public static final String UI_DEFAULTS_COLOR_CHIP_SIZE = "colorwheel_components.JxColorComponent.color_chip_size";
    public static final String UI_DEFAULTS_ARCW = "colorwheel_components.JxColorComponent.arcw";
    public static final String UI_DEFAULTS_ARCH = "colorwheel_components.JxColorComponent.arch";
    public static final String UI_DEFAULTS_SHADOW_DIRECTION = "colorwheel_components.JxColorComponent.shadow_direction";
    public static final String UI_DEFAULTS_SHADOW_OPACITY = "colorwheel_components.JxColorComponent.shadow_opacity";
    private static ContrastColorProvider contrastColorProvider = null;
    private Color gridlineColor;
    private Color outlineColor;
    private float gridlineWidth;
    private float outlineWidth;
    protected int arcw;
    protected int arch;
    protected Point2D shadowDirection;
    protected float shadowOpacity;
    private Dimension preferredColorCardSize;
    private int preferredColorChipSize;

    public JxColorComponent() {
        this.installColorCardDefaults(UI_DEFAULTS_COLOR_CARD_SIZE, UI_DEFAULTS_COLOR_CHIP_SIZE);
        Integer l_arc = (Integer)UIManager.get(UI_DEFAULTS_ARCW);
        this.arcw = l_arc != null ? l_arc : 0;
        l_arc = (Integer)UIManager.get(UI_DEFAULTS_ARCH);
        this.arch = l_arc != null ? l_arc : 0;
        this.shadowDirection = (Point2D)UIManager.get(UI_DEFAULTS_SHADOW_DIRECTION);
        Float l_opacity = (Float)UIManager.get(UI_DEFAULTS_SHADOW_OPACITY);
        this.shadowOpacity = l_opacity != null ? l_opacity.floatValue() : 1.0f;
    }

    protected void installFont(String defaultFont) {
        this.setFont(UIManager.getFont(defaultFont));
    }

    protected void installColorDefaults(String defaultBackground, String defaultForeground) {
        this.setBackground(UIManager.getColor(defaultBackground));
        this.setForeground(UIManager.getColor(defaultForeground));
    }

    protected void installGridlineDefaults(String defaultGridlineColor, String defaultGridlineWidth) {
        Float l_width;
        this.gridlineColor = UIManager.getColor(defaultGridlineColor);
        if (this.gridlineColor == null) {
            this.gridlineColor = Color.black;
        }
        this.gridlineWidth = (l_width = (Float)UIManager.get(defaultGridlineWidth)) == null ? 1.0f : l_width.floatValue();
    }

    protected void installOutlineDefaults(String defaultOutlineColor, String defaultOutlineWidth) {
        Float l_width;
        this.outlineColor = UIManager.getColor(defaultOutlineColor);
        if (this.outlineColor == null) {
            this.outlineColor = Color.black;
        }
        this.outlineWidth = (l_width = (Float)UIManager.get(defaultOutlineWidth)) == null ? 1.0f : l_width.floatValue();
    }

    protected final void installColorCardDefaults(String defaultColorCardSize, String defaultColorChipSize) {
        int l_defaultWidth = 96;
        int l_defaultColorChipSize = 32;
        this.preferredColorCardSize = UIManager.getDimension(defaultColorCardSize);
        if (this.preferredColorCardSize == null) {
            this.preferredColorCardSize = new Dimension(96, 128);
        }
        this.preferredColorChipSize = UIManager.getInt(defaultColorChipSize);
        if (this.preferredColorChipSize == 0) {
            this.preferredColorChipSize = 32;
        }
    }

    protected Dimension getPreferredColorCardSize() {
        return this.preferredColorCardSize;
    }

    protected int getPreferredColorChipSize() {
        return this.preferredColorChipSize;
    }

    protected Dimension getPreferredLayoutSize() {
        return null;
    }

    public Color getGridlineColor() {
        return this.gridlineColor;
    }

    public void setGridlineColor(Color gridlineColor) {
        this.gridlineColor = gridlineColor;
    }

    public float getGridlineWidth() {
        return this.gridlineWidth;
    }

    public void setGridlineWidth(float gridlineWidth) {
        this.gridlineWidth = gridlineWidth;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    public float getOutlineWidth() {
        return this.outlineWidth;
    }

    public void setOutlineWidth(float outlineWidth) {
        this.outlineWidth = outlineWidth;
    }

    protected Color getTranslucentColor(Color color, float alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0f * alpha));
    }

    protected Color getContrastColor(Color color) {
        if (contrastColorProvider != null) {
            return contrastColorProvider.provide(color);
        }
        return Color.white;
    }

    public static void setContrastColorProvider(ContrastColorProvider provider) {
        contrastColorProvider = provider;
    }

    public static interface ContrastColorProvider {
        public Color provide(Color var1);
    }
}

