/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.components;

import com.valeras.colorwheel_harmony.ui.shapes.StrokeAware;
import com.valeras.colorwheel_harmony.ui.swing.AbstractNoColorPaintFactory;
import com.valeras.colorwheel_harmony.ui.swing.components.CustomShapeComponent;
import com.valeras.colorwheel_harmony.ui.swing.components.JxColorComponent;
import com.valeras.colorwheel_harmony.ui.swing.icons.BasicColorCardIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;

public class JxColorCard
extends JxColorComponent
implements CustomShapeComponent {
    private static final String UI_MANAGER_COMPONENT_NAME = "colorwheel_components.ColorCard.";
    public static final String UI_DEFAULTS_FONT = "colorwheel_components.ColorCard.font";
    public static final String UI_DEFAULTS_OUTLINE_COLOR = "colorwheel_components.ColorCard.outline_color";
    public static final String UI_DEFAULTS_OUTLINE_WIDTH = "colorwheel_components.ColorCard.outline_width";
    public static final String UI_DEFAULTS_GRIDLINE_COLOR = "colorwheel_components.ColorCard.gridline_color";
    public static final String UI_DEFAULTS_GRIDLINE_WIDTH = "colorwheel_components.ColorCard.gridline_width";
    public static final String UI_DEFAULTS_BACKGROUND = "colorwheel_components.ColorCard.background";
    public static final String UI_DEFAULTS_FOREGROUND = "colorwheel_components.ColorCard.foreground";
    private final ArrayList<ActionListener> actionListeners;
    protected final ActionEvent defaultActionEvent;
    protected Icon icon;
    private boolean selected;
    protected BasicColorCardIcon colorCardIcon;
    private Shape outline;
    private String text;
    private int rowCount;
    private ColorCardLayout layout;
    private boolean smartOutlineColor;

    public JxColorCard(int textPosition, int rows) {
        HashMap<RenderingHints.Key, Object> l_renderingHints = new HashMap<RenderingHints.Key, Object>();
        this.layout = new ColorCardLayout();
        this.setLayout(this.layout);
        this.installFont(UI_DEFAULTS_FONT);
        this.installColorDefaults(UI_DEFAULTS_BACKGROUND, UI_DEFAULTS_FOREGROUND);
        this.installGridlineDefaults(UI_DEFAULTS_GRIDLINE_COLOR, UI_DEFAULTS_GRIDLINE_WIDTH);
        this.installOutlineDefaults(UI_DEFAULTS_OUTLINE_COLOR, UI_DEFAULTS_OUTLINE_WIDTH);
        l_renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.colorCardIcon = new BasicColorCardIcon(16, 16, this.getBackground(), this.getForeground(), this.getOutlineColor(), this.arcw, this.arch);
        this.colorCardIcon.setTextRows(rows);
        this.colorCardIcon.setFont(this.getFont());
        this.colorCardIcon.setStroke(new BasicStroke(this.getOutlineWidth()));
        this.colorCardIcon.setNoPaint(AbstractNoColorPaintFactory.createNoColorPaint());
        this.colorCardIcon.setRenderingHints(l_renderingHints);
        this.smartOutlineColor = false;
        this.selected = false;
        this.outline = null;
        this.rowCount = rows;
        this.actionListeners = new ArrayList();
        this.defaultActionEvent = new ActionEvent(this, 1001, null);
        this.addMouseListener(new ColorCardComponentMouseAdapter());
    }

    public void setCaptionText(String text) {
        this.text = text;
        this.colorCardIcon.setLabelText(text);
    }

    public void setCommentText(String text) {
        this.colorCardIcon.setCommentText(text);
    }

    public String getCaptionText() {
        return this.text;
    }

    public void setColor(Color color) {
        this.colorCardIcon.setPaint(color);
        if (this.smartOutlineColor) {
            this.colorCardIcon.setOutlineColor(color != null ? color : this.getOutlineColor());
        }
        this.repaint();
    }

    public void setSecondaryColor(Color color) {
        this.colorCardIcon.setSecondColor(color);
        this.repaint();
    }

    public final boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean b) {
        this.selected = b;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void setOutlineColorSmart(boolean smart) {
        this.smartOutlineColor = smart;
    }

    public boolean isOutlineColorSmart() {
        return this.smartOutlineColor;
    }

    public void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    protected void fireActionPerformed(ActionEvent event) {
        for (ActionListener l : this.actionListeners) {
            l.actionPerformed(event);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Insets l_insets = this.getInsets();
        this.colorCardIcon.paintIcon(this, g, l_insets.left, l_insets.top);
    }

    @Override
    public Shape getComponentShape() {
        Rectangle l_rect = StrokeAware.createOverlayRectangle(this.outline.getBounds(), this.getOutlineWidth());
        return new RoundRectangle2D.Double(l_rect.x, l_rect.y, l_rect.width, l_rect.height, this.arcw, this.arch);
    }

    @Override
    protected Dimension getPreferredLayoutSize() {
        return this.getPreferredColorCardSize();
    }

    private class ColorCardLayout
    implements LayoutManager {
        private final Dimension defaultSize;

        public ColorCardLayout() {
            this.defaultSize = JxColorCard.this.getPreferredLayoutSize();
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            throw new UnsupportedOperationException("This layout does not support component addition.");
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            throw new UnsupportedOperationException("This layout does not support component removal.");
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Insets l_insets = JxColorCard.this.getInsets();
            int l_width = this.defaultSize.width;
            int l_height = this.defaultSize.height;
            return new Dimension(l_width += l_insets.left + l_insets.right, l_height += l_insets.top + l_insets.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets l_insets = JxColorCard.this.getInsets();
            Dimension l_size = JxColorCard.this.getSize();
            Rectangle l_bounds = new Rectangle(l_insets.left, l_insets.top, l_size.width - l_insets.left - l_insets.right, l_size.height - l_insets.top - l_insets.bottom);
            JxColorCard.this.colorCardIcon.setSize(new Dimension(l_bounds.width, l_bounds.height));
            JxColorCard.this.outline = JxColorCard.this.colorCardIcon.getShape(l_bounds.x, l_bounds.y);
        }
    }

    private class ColorCardComponentMouseAdapter
    extends MouseAdapter {
        private ColorCardComponentMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JxColorCard.this.fireActionPerformed(JxColorCard.this.defaultActionEvent);
        }
    }
}

