/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionListener;

public class JxAssortmentPanel
extends JPanel {
    private static final Dimension PREFFERED_DIMENSION = new Dimension(400, 300);
    private final JScrollPane scrollPane;
    private final JList list;
    private ComboBoxModel model;

    public JxAssortmentPanel(ListCellRenderer listCellRenderer) {
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(20, 30);
        this.scrollPane.setPreferredSize(PREFFERED_DIMENSION);
        this.list = new JList();
        this.list.setCellRenderer(listCellRenderer);
        this.list.setLayoutOrientation(2);
        this.list.setVisibleRowCount(-1);
        this.scrollPane.setViewportView(this.list);
        this.add((Component)this.scrollPane, "Center");
        this.setBackground(this.scrollPane.getBackground());
        this.addComponentListener(new DefaultComponentListener());
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.list.addListSelectionListener(l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.list.removeListSelectionListener(l);
    }

    public void setAssortmentModel(ComboBoxModel model) {
        this.model = model;
        this.list.setModel(this.model);
        this.list.setSelectedValue(this.model.getSelectedItem(), true);
    }

    public Object getAssortmentValue() {
        return this.list.getSelectedValue();
    }

    public void setAssortmentValue(Object value, boolean shouldScroll) {
        this.list.setSelectedValue(value, shouldScroll);
    }

    private class DefaultComponentListener
    implements ComponentListener {
        private DefaultComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Insets l_insets = JxAssortmentPanel.this.getInsets();
            int l_width = JxAssortmentPanel.this.getWidth();
            int l_height = JxAssortmentPanel.this.getHeight();
            JxAssortmentPanel.this.scrollPane.setPreferredSize(new Dimension(l_width - (l_insets.left + l_insets.right), l_height - (l_insets.top + l_insets.bottom)));
            JxAssortmentPanel.this.revalidate();
            JxAssortmentPanel.this.repaint();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }
}

