/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class HotSpotButtonIcon
implements Icon {
    private int width;
    private int height;
    private boolean active;
    private int activeRegion;
    private final Color color;
    private int arcw;
    private int arch;

    public HotSpotButtonIcon(int width, int height, Color color) {
        this.width = width;
        this.height = height;
        this.color = color;
        this.active = false;
        this.arcw = this.arch = height / 4;
        this.activeRegion = -1;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    protected int getArcWidth() {
        return this.arcw;
    }

    protected int getArcHeight() {
        return this.arch;
    }

    public Color getColor() {
        return this.color;
    }

    public void setActive(boolean flag) {
        this.active = flag;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActiveRegion(int index) {
        this.activeRegion = index;
    }

    public int getActiveRegion() {
        return this.activeRegion;
    }

    public int getHotSpotRegion(int x, int y) {
        return 0;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D l_gr2 = (Graphics2D)g.create();
        Color l_color = this.isActive() ? this.color : this.createTranslucentColor(this.color);
        l_gr2.setColor(l_color);
        l_gr2.drawRect(x, y, this.width - 1, this.height - 1);
        l_gr2.dispose();
    }

    protected Color createTranslucentColor(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), 64);
    }
}

