/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.components;

import com.valeras.colorwheel_harmony.ui.swing.components.JxColorCard;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;

public class ColorCardGroup
implements ActionListener,
ItemSelectable {
    protected final ArrayList<JxColorCard> colorCards = new ArrayList();
    protected final ArrayList<ItemListener> itemListeners = new ArrayList();
    private int selectedIndex = -1;

    public void setSelectedIndex(int index) {
        if (index >= this.colorCards.size()) {
            throw new RuntimeException("Index is out of bounds.");
        }
        if (this.selectedIndex != index) {
            ItemEvent e;
            if (this.selectedIndex != -1) {
                e = new ItemEvent(this, 701, this.colorCards.get(this.selectedIndex), 2);
                this.fireItemStateChanged(e);
            }
            this.selectedIndex = index;
            if (index >= 0) {
                e = new ItemEvent(this, 701, this.colorCards.get(this.selectedIndex), 1);
                this.fireItemStateChanged(e);
            }
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void add(JxColorCard cs) {
        this.colorCards.add(cs);
        cs.addActionListener(this);
    }

    public void remove(JxColorCard cs) {
        this.colorCards.remove(cs);
        cs.removeActionListener(this);
    }

    public int getSampleCount() {
        return this.colorCards.size();
    }

    public void clearSelection() {
        this.setSelectedIndex(-1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JxColorCard l_sample;
        if (this.selectedIndex >= 0) {
            l_sample = this.colorCards.get(this.selectedIndex);
            l_sample.setSelected(false);
        }
        l_sample = (JxColorCard)e.getSource();
        this.setSelectedIndex(this.colorCards.indexOf(l_sample));
        l_sample.setSelected(true);
    }

    protected void fireItemStateChanged(ItemEvent event) {
        for (ItemListener l : this.itemListeners) {
            l.itemStateChanged(event);
        }
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] l_selection = null;
        if (this.selectedIndex >= 0) {
            l_selection = new Object[]{this.colorCards.get(this.selectedIndex)};
        }
        return l_selection;
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.itemListeners.add(l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.itemListeners.remove(l);
    }
}

