/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.border.AbstractBorder;

public class RoundLineBorder
extends AbstractBorder {
    private static final int INNER_GAP = 0;
    private final Insets insets;
    private final Color color;
    private final int arc;
    private final Stroke stroke;
    private final Stroke stroke2;
    private final float thickness;

    public RoundLineBorder(Color color, float thickness, int arc) {
        this.color = color;
        this.arc = arc;
        this.thickness = thickness;
        int l_inset = Math.max((int)(thickness + 0.5f), arc / 2) + 0;
        this.insets = new Insets(l_inset, l_inset, l_inset, l_inset);
        this.stroke = new BasicStroke(1.0f);
        this.stroke2 = new BasicStroke(1.5f);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        if (insets != null) {
            insets.set(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
            return insets;
        }
        return this.insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D l_g = (Graphics2D)g.create();
        Rectangle l_rect = new Rectangle(x, y, width - 1, height - 1);
        int l_iteration = (int)(this.thickness + 0.5f);
        if (width <= 0 || height <= 0) {
            return;
        }
        Color l_bkColor = c.getBackground();
        Color l_borderColor = l_bkColor.darker();
        int l_dr = (l_bkColor.getRed() - l_borderColor.getRed()) / l_iteration;
        int l_dg = (l_bkColor.getGreen() - l_borderColor.getGreen()) / l_iteration;
        int l_db = (l_bkColor.getBlue() - l_borderColor.getBlue()) / l_iteration;
        l_g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = 0; i < l_iteration; ++i) {
            l_g.setStroke(i == 0 || i == l_iteration - 1 ? this.stroke : this.stroke2);
            Color l_color = new Color(l_borderColor.getRed() + l_dr * i, l_borderColor.getGreen() + l_dg * i, l_borderColor.getBlue() + l_db * i);
            l_g.setColor(l_color);
            l_g.drawRoundRect(l_rect.x + i, l_rect.y + i, l_rect.width - i * 2, l_rect.height - i * 2, this.arc, this.arc);
        }
        l_g.dispose();
    }
}

