/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.border;

import com.valeras.colorwheel_harmony.ui.swing.components.CustomShapeComponent;
import com.valeras.effects2d.DropShadowIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;

public class DropShadowBorder
extends AbstractBorder {
    private static final String PROPERTY_SHADOW_BORDER_OUTLINE = "shadow_border.outline";
    private final Insets insets;
    private final Point2D tx;
    private final float opacity;
    private DropShadowIcon shadowIcon;

    public DropShadowBorder(Point2D tx, float opacity) {
        this.tx = tx;
        this.opacity = opacity;
        this.insets = this.getInsets(tx);
        this.shadowIcon = null;
    }

    private Insets getInsets(Point2D tx) {
        Insets l_insets = new Insets(0, 0, 0, 0);
        int l_x = (int)tx.getX();
        int l_y = (int)tx.getY();
        if (l_x >= 0) {
            l_insets.right = l_x;
        } else {
            l_insets.left = -l_x;
        }
        if (l_y >= 0) {
            l_insets.bottom = l_y;
        } else {
            l_insets.top = -l_y;
        }
        return l_insets;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        if (insets != null) {
            insets.set(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
            return insets;
        }
        return this.insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    private DropShadowIcon getSoftShadowIcon(Component c, int x, int y, int width, int height) {
        Shape l_outline = null;
        if (this.shadowIcon == null || this.shadowIcon.getIconWidth() != width || this.shadowIcon.getIconHeight() != height) {
            if (c instanceof CustomShapeComponent) {
                l_outline = ((CustomShapeComponent)((Object)c)).getComponentShape();
            } else if (c instanceof JComponent) {
                l_outline = (Shape)((JComponent)c).getClientProperty(PROPERTY_SHADOW_BORDER_OUTLINE);
            }
            if (l_outline == null) {
                l_outline = new Rectangle(x + this.insets.left, y + this.insets.top, width - this.insets.right, height - this.insets.bottom);
            }
            this.shadowIcon = DropShadowIcon.createVergeShadow(l_outline, this.tx, this.opacity, 1.0f);
        }
        return this.shadowIcon;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        DropShadowIcon l_shadow = this.getSoftShadowIcon(c, x, y, width, height);
        l_shadow.paintIcon(c, g, x, y);
    }

    public static void putOutline(JComponent c, Shape shape) {
        c.putClientProperty(PROPERTY_SHADOW_BORDER_OUTLINE, shape);
    }
}

