/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing;

import com.valeras.colorwheel_harmony.resources.HarmonyResources;
import com.valeras.colorwheel_harmony.ui.swing.IconProvider;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class JLFGRIconProvider
implements IconProvider {
    private static final String ICON_PATH = "icons/jlfgr/toolbarButtonGraphics/";
    private static final String ICON_EXT = ".gif";
    private static HashMap<String, String> iconNames = null;
    private int smallSize = 16;

    public JLFGRIconProvider() {
        if (iconNames == null) {
            iconNames = new HashMap();
            JLFGRIconProvider.populateIconNames(iconNames);
        }
    }

    private static void populateIconNames(HashMap<String, String> map) {
        map.put("action.file.new", "general/New");
        map.put("action.file.open", "general/Open");
        map.put("action.file.save", "general/Save");
        map.put("action.file.saveas", "general/SaveAs");
        map.put("action.file.page_setup", "general/PageSetup");
        map.put("action.file.print", "general/Print");
        map.put("action.edit.cut", "general/Cut");
        map.put("action.edit.copy", "general/Copy");
        map.put("action.edit.paste", "general/Paste");
        map.put("action.edit.comment", "general/Edit");
        map.put("action.help.about", "general/About");
        map.put("action.tools.options", "general/Preferences");
        map.put("action.help.contact_support", "general/ComposeMail");
    }

    @Override
    public void setSmallIconPreferredSize(Dimension size) {
        int l_d24;
        int l_d16 = Math.abs(16 - size.height);
        this.smallSize = l_d16 < (l_d24 = Math.abs(24 - size.height)) ? 16 : 24;
    }

    @Override
    public Icon getSmallIcon(String iconId) {
        ImageIcon l_icon = null;
        BufferedImage l_image = null;
        String l_name = iconNames.get(iconId);
        if (l_name == null) {
            return null;
        }
        String l_path = ICON_PATH + l_name + Integer.toString(this.smallSize) + ICON_EXT;
        InputStream l_is = HarmonyResources.class.getResourceAsStream(l_path);
        if (l_is != null) {
            try {
                l_image = ImageIO.read(l_is);
                l_is.close();
            }
            catch (IOException ex) {
                Logger.getLogger(JLFGRIconProvider.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (l_image != null) {
            l_icon = new ImageIcon(l_image);
        }
        return l_icon;
    }

    @Override
    public void setLargeIconPreferredSize(Dimension size) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Icon getLargeIcon(String iconId) {
        return null;
    }
}

