/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing;

import com.valeras.colorwheel_harmony.ui.swing.AbstractComponentBorderFactory;
import com.valeras.colorwheel_harmony.ui.swing.AbstractDropShadowBorderFactory;
import com.valeras.colorwheel_harmony.ui.swing.border.DropShadowBorder;
import com.valeras.colorwheel_harmony.ui.swing.border.RoundLineBorder;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JMenuItem;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class DefaultComponentBorderFactory
extends AbstractComponentBorderFactory {
    final AbstractDropShadowBorderFactory dropShadowBorderFactory;
    private final Color color;
    private final Font titleFont;
    private final boolean defaultBorder;
    private final int arc;

    public DefaultComponentBorderFactory(AbstractDropShadowBorderFactory factory, int arc, boolean nativeLNF) {
        this.dropShadowBorderFactory = factory;
        this.titleFont = new JMenuItem().getFont();
        this.color = Color.darkGray;
        this.defaultBorder = !nativeLNF;
        this.arc = arc;
    }

    @Override
    public Border createBorder(String title, boolean dropShadow) {
        TitledBorder l_title = this.defaultBorder ? new TitledBorder(title) : new TitledBorder(new RoundLineBorder(Color.GRAY, 3.0f, this.arc), title, 1, 1);
        l_title.setTitleFont(this.titleFont);
        AbstractBorder l_border = l_title;
        if (dropShadow) {
            DropShadowBorder l_shadowBorder = this.dropShadowBorderFactory.createBorder();
            l_border = new CompoundBorder(l_title, l_shadowBorder);
        }
        return l_border;
    }
}

