/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing;

import com.valeras.colorwheel_harmony.ui.swing.AbstractColorWheelSkinFactory;
import com.valeras.colorwheel_harmony.ui.swing.components.colorwheel_renderer.AbstractColorWheelSkin;
import com.valeras.colorwheel_harmony.ui.swing.components.colorwheel_renderer.ColorWheelColorSkin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.util.HashMap;

public class DefaultColorWheelSkinFactory
extends AbstractColorWheelSkinFactory {
    public static final String OFF_WHITE = "colorwheel_skin.off_white";
    public static final String WHITE_MATTE = "colorwheel_skin.white_matte";
    public static final String SMOKED_GLASS = "colorwheel_skin.smoked_glass";
    private final HashMap<String, AbstractColorWheelSkin> skins;
    private final BasicStroke stroke;
    private final Color offWhite;

    public DefaultColorWheelSkinFactory(BasicStroke stroke, Color offWhite) {
        this.stroke = stroke;
        this.offWhite = offWhite;
        this.skins = new HashMap();
        this.skins.put(OFF_WHITE, new ColorWheelColorSkin(OFF_WHITE, this.offWhite, Color.white, Color.black, this.stroke, 1.0f));
        this.skins.put(WHITE_MATTE, new ColorWheelColorSkin(WHITE_MATTE, Color.white, Color.white, Color.darkGray, this.stroke, 0.75f));
        this.skins.put(SMOKED_GLASS, new ColorWheelColorSkin(SMOKED_GLASS, Color.black, Color.black, Color.lightGray, this.stroke, 0.75f));
    }

    public BasicStroke getDefaultStroke() {
        return this.stroke;
    }

    public void add(AbstractColorWheelSkin skin) {
        this.skins.put(skin.getName(), skin);
    }

    @Override
    public AbstractColorWheelSkin createSkin(String name) {
        return this.skins.get(name);
    }

    @Override
    public AbstractColorWheelSkin createDefaultSkin() {
        return this.skins.get(WHITE_MATTE);
    }
}

