/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing;

import com.valeras.colorwheel_harmony.ui.swing.AbstractColorWheelIconFactory;
import com.valeras.colorwheel_harmony.ui.swing.icons.ColorWheelIcon;
import com.valeras.effects2d.DropShadowIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Arrays;
import javax.swing.Icon;

public class DefaultColorWheelIconFactory
extends AbstractColorWheelIconFactory {
    protected final Color outline;
    protected final Stroke stroke;
    protected final Color[] spectrum;
    protected final double angleStart;
    protected final Point2D dropShadow;
    protected final float shadowOpacity;
    protected int dx;
    protected int dy;
    protected int width;
    protected int height;

    public DefaultColorWheelIconFactory(int width, int height, Color[] spectrum, Color outline, Stroke stroke, Point2D dropShadow, float shadowOpacity) {
        this.width = width;
        this.height = height;
        this.spectrum = Arrays.copyOf(spectrum, spectrum.length);
        this.outline = outline;
        this.stroke = stroke;
        this.dropShadow = dropShadow;
        this.shadowOpacity = shadowOpacity;
        this.angleStart = 0.0;
        this.dy = 0;
        this.dx = 0;
        if (dropShadow != null) {
            this.dx = (int)(dropShadow.getX() + 0.5);
            this.dy = (int)(dropShadow.getY() + 0.5);
        }
    }

    @Override
    public Icon createIcon() {
        Icon l_icon = null;
        if (this.dropShadow != null) {
            ColorWheelIcon l_colorWheelIcon = new ColorWheelIcon(this.width - this.dx, this.height - this.dy, this.spectrum, this.angleStart, this.outline, this.stroke);
            Ellipse2D.Double l_shape = new Ellipse2D.Double(0.0, 0.0, this.width - this.dx, this.height - this.dy);
            DropShadowIcon l_shadowIcon = DropShadowIcon.createDropShadow(l_shape, this.dropShadow, this.shadowOpacity);
            l_icon = new CombinedIcon(this.width, this.height, l_shadowIcon, l_colorWheelIcon);
        } else {
            l_icon = new ColorWheelIcon(this.width, this.height, this.spectrum, this.angleStart, this.outline, this.stroke);
        }
        return l_icon;
    }

    private class CombinedIcon
    implements Icon {
        private final int width;
        private final int height;
        final Icon background;
        final Icon foreground;

        public CombinedIcon(int width, int height, Icon background, Icon foreground) {
            this.width = width;
            this.height = height;
            this.background = background;
            this.foreground = foreground;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.background.paintIcon(c, g, x, y);
            this.foreground.paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }
}

