/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing;

import com.valeras.colorwheel_harmony.ui.swing.AbstractApplicationIconFactory;
import com.valeras.colorwheel_harmony.ui.swing.IconProvider;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class DefaultApplicationIconFactory
extends AbstractApplicationIconFactory {
    private static final Color PROCESS_RED = new Color(15674157);
    private static final Color PROCESS_YELLOW = new Color(16245268);
    private static final Color PROCESS_BLUE = new Color(37321);
    private static final Color transparentColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private static final Dimension[] defaultIconImageDimensions = new Dimension[]{new Dimension(16, 16), new Dimension(24, 24), new Dimension(32, 32), new Dimension(48, 48), new Dimension(64, 64), new Dimension(128, 128), new Dimension(256, 256), new Dimension(512, 512)};
    private final ArrayList<Image> applicationImageList;
    private final ArrayList<Image> documentImageList;
    private final ArrayList<Image> colorChartImageList;
    private final Image applicationIconImage;
    private final Color iconOutlineColor;
    private final IconProvider iconProvider;

    public DefaultApplicationIconFactory(IconProvider iconProvider, Color iconOutlineColor) {
        this.iconProvider = iconProvider;
        this.iconOutlineColor = iconOutlineColor;
        this.applicationImageList = new ArrayList(defaultIconImageDimensions.length);
        this.documentImageList = new ArrayList(defaultIconImageDimensions.length);
        this.colorChartImageList = new ArrayList(defaultIconImageDimensions.length);
        for (int i = 0; i < defaultIconImageDimensions.length; ++i) {
            Dimension l_size = defaultIconImageDimensions[i];
            Image l_iconImage = this.createApplicationIconImage(l_size.width, l_size.height, true);
            this.applicationImageList.add(l_iconImage);
            l_iconImage = this.createDocumentIconImage(l_size.width, l_size.height);
            this.documentImageList.add(l_iconImage);
            l_iconImage = this.createColorChartIconImage(l_size.width, l_size.height);
            this.colorChartImageList.add(l_iconImage);
        }
        this.applicationIconImage = this.applicationImageList.get(1);
    }

    @Override
    public List<Image> getApplicationIconImages() {
        return this.applicationImageList;
    }

    @Override
    public List<Image> getDocumentIconImages() {
        return this.documentImageList;
    }

    @Override
    public Image getApplicationIconImage() {
        return this.applicationIconImage;
    }

    @Override
    public ImageIcon createIcon(int width, int height) {
        return new ImageIcon(this.createApplicationIconImage(width, height, true));
    }

    private Image createDocumentIconImage(int width, int height) {
        Path2D.Float l_path = new Path2D.Float();
        BufferedImage l_image = new BufferedImage(width, height, 2);
        Graphics2D l_gr = l_image.createGraphics();
        l_gr.setColor(transparentColor);
        l_gr.fillRect(0, 0, l_image.getWidth(), l_image.getHeight());
        int l_dx = (width - height * 3 / 4) / 2;
        int l_dy = 1;
        Rectangle l_frame = new Rectangle(l_dx, l_dy, width - l_dx * 2, height - l_dy * 2);
        int l_dc = l_frame.height / 4;
        ((Path2D)l_path).moveTo(l_frame.x, l_frame.y);
        ((Path2D)l_path).lineTo(l_frame.x + l_frame.width - l_dc, l_frame.y);
        ((Path2D)l_path).lineTo(l_frame.x + l_frame.width - l_dc, l_frame.y);
        ((Path2D)l_path).lineTo(l_frame.x + l_frame.width, l_frame.y + l_dc);
        ((Path2D)l_path).lineTo(l_frame.x + l_frame.width, l_frame.y + l_frame.height - 1);
        ((Path2D)l_path).lineTo(l_frame.x, l_frame.y + l_frame.height - 1);
        l_path.closePath();
        l_gr.setPaint(Color.white);
        l_gr.fill(l_path);
        l_gr.setColor(Color.gray);
        l_gr.draw(l_path);
        l_path = new Path2D.Float();
        ((Path2D)l_path).moveTo(l_frame.x + l_frame.width - l_dc, l_frame.y);
        ((Path2D)l_path).lineTo(l_frame.x + l_frame.width - l_dc, l_frame.y + l_dc);
        ((Path2D)l_path).lineTo(l_frame.x + l_frame.width, l_frame.y + l_dc);
        l_path.closePath();
        l_gr.setColor(Color.gray);
        l_gr.draw(l_path);
        int l_iconSize = (int)(l_frame.getWidth() * 2.0 / 3.0);
        BufferedImage l_icon = (BufferedImage)this.createApplicationIconImage(l_iconSize, l_iconSize, false);
        l_gr.drawImage(l_icon, null, l_frame.x + 1, l_frame.y + l_frame.height - l_iconSize - 1);
        l_gr.dispose();
        return l_image;
    }

    private Image createApplicationIconImage(int width, int height, boolean gap) {
        int l_count = 3;
        float l_angleStart = 0.0f;
        Color[] l_colors = new Color[]{PROCESS_BLUE, PROCESS_YELLOW, PROCESS_RED};
        int l_gap = gap ? width / 16 : 0;
        BufferedImage l_image = new BufferedImage(width, height, 2);
        Graphics2D l_gr = l_image.createGraphics();
        l_gr.setColor(transparentColor);
        l_gr.fillRect(0, 0, l_image.getWidth(), l_image.getHeight());
        float l_extent = 30.0f;
        Rectangle2D.Double l_frame = new Rectangle2D.Double();
        l_frame.setFrameFromCenter(new Point2D.Double(l_gap, height - l_gap - 1), new Point2D.Double(width - l_gap - 1, l_gap));
        l_gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = 0; i < 3; ++i) {
            Arc2D.Double l_arc = new Arc2D.Double(l_frame, 0.0f + l_extent * (float)i, l_extent, 2);
            l_gr.setPaint(l_colors[i]);
            l_gr.fill(l_arc);
            l_gr.setColor(this.iconOutlineColor);
            l_gr.draw(l_arc);
        }
        l_gr.setColor(transparentColor);
        l_gr.setComposite(AlphaComposite.Clear);
        l_gr.fillRect(0, 0, l_gap, height);
        l_gr.fillRect(0, height - l_gap, width, l_gap);
        l_gr.dispose();
        return l_image;
    }

    @Override
    protected Icon provideMenuIcon(String iconId) {
        return this.iconProvider.getSmallIcon(iconId);
    }

    private Image createColorChartIconImage(int width, int height) {
        int l_gap = width / 16;
        Color[] l_colors = new Color[]{PROCESS_RED, PROCESS_YELLOW, PROCESS_BLUE};
        int l_arc = width / 32;
        boolean l_gradient = true;
        BufferedImage l_image = new BufferedImage(width, height, 2);
        Graphics2D l_gr = l_image.createGraphics();
        l_gr.setColor(transparentColor);
        l_gr.fillRect(0, 0, l_image.getWidth(), l_image.getHeight());
        l_gr.setColor(Color.white);
        l_gr.fillRect(l_gap, l_gap, width - l_gap * 2, height - l_gap * 2);
        int l_swatchWidth = (width - l_gap * 5) / 2;
        int l_swatchHeight = (height - l_gap * 6) / 3;
        l_gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = 0; i < 3; ++i) {
            Color l_color = l_colors[i];
            int x = l_gap * 2;
            int y = i * (l_gap + l_swatchHeight) + l_gap * 2;
            GradientPaint l_paint = new GradientPaint(x, y, l_color.brighter(), x, y + l_swatchHeight, l_color);
            l_gr.setPaint(l_paint);
            if (l_arc > 0) {
                l_gr.fillRoundRect(x, y, l_swatchWidth, l_swatchHeight, l_arc, l_arc);
            } else {
                l_gr.fillRect(x, y, l_swatchWidth, l_swatchHeight);
            }
            l_paint = new GradientPaint(x, y, l_color, x, y + l_swatchHeight, l_color.darker());
            l_gr.setPaint(l_paint);
            if (l_arc > 0) {
                l_gr.fillRoundRect(x + l_swatchWidth + l_gap, y, l_swatchWidth, l_swatchHeight, l_arc, l_arc);
                continue;
            }
            l_gr.fillRect(x + l_swatchWidth + l_gap, y, l_swatchWidth, l_swatchHeight);
        }
        l_gr.dispose();
        return l_image;
    }

    @Override
    public List<Image> getColorChartIconImages() {
        return this.colorChartImageList;
    }

    @Override
    public Image getColorChartIconImage() {
        return this.colorChartImageList.get(1);
    }
}

