/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public abstract class AbstractApplicationIconFactory {
    private static AbstractApplicationIconFactory instance;
    private static final Map<Integer, String> optionPaneIconNames;

    protected AbstractApplicationIconFactory() {
    }

    public abstract List<Image> getApplicationIconImages();

    public abstract List<Image> getColorChartIconImages();

    public abstract List<Image> getDocumentIconImages();

    public abstract Image getApplicationIconImage();

    public abstract Image getColorChartIconImage();

    public abstract ImageIcon createIcon(int var1, int var2);

    protected abstract Icon provideMenuIcon(String var1);

    public static void setFactory(AbstractApplicationIconFactory factory) {
        instance = factory;
    }

    public static AbstractApplicationIconFactory getInstance() {
        return instance;
    }

    public static Icon createApplicationIcon(int width, int height) {
        return instance.createIcon(width, height);
    }

    public static Icon getMenuIcon(String iconId) {
        return instance.provideMenuIcon(iconId);
    }

    public static Icon deriveJOptionPaneIcon(int messageType, Component component, int width, int height) {
        AffineTransformOp l_op = null;
        Icon l_icon = UIManager.getIcon(optionPaneIconNames.get(messageType));
        if (l_icon == null) {
            return null;
        }
        BufferedImage l_image = new BufferedImage(l_icon.getIconWidth(), l_icon.getIconHeight(), 2);
        Color l_emptyColor = new Color(0, 0, 0, 0);
        Graphics2D l_gr = (Graphics2D)l_image.getGraphics();
        l_gr.setBackground(l_emptyColor);
        l_gr.clearRect(0, 0, l_image.getWidth(), l_image.getHeight());
        l_icon.paintIcon(component, l_gr, 0, 0);
        float k = Math.min((float)width / (float)l_image.getWidth(), (float)height / (float)l_image.getHeight());
        l_op = new AffineTransformOp(AffineTransform.getScaleInstance(k, k), 3);
        l_image = l_op.filter(l_image, null);
        return new ImageIcon(l_image);
    }

    static {
        optionPaneIconNames = new HashMap<Integer, String>();
        optionPaneIconNames.put(new Integer(3), "OptionPane.questionIcon");
        optionPaneIconNames.put(new Integer(1), "OptionPane.informationIcon");
        optionPaneIconNames.put(new Integer(0), "OptionPane.errorIcon");
        optionPaneIconNames.put(new Integer(2), "OptionPane.warningIcon");
    }
}

