/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.shapes;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class StrokeAware {
    public static Rectangle2D createStrokeAwareRectangle2D(Rectangle2D bounds, Stroke stroke) {
        double l_x = bounds.getX();
        double l_y = bounds.getY();
        double l_width = bounds.getWidth();
        double l_height = bounds.getHeight();
        if (stroke instanceof BasicStroke) {
            int l_delta;
            float l_lineWidth = ((BasicStroke)stroke).getLineWidth();
            float l_overlay = (l_lineWidth - 1.0f) / 2.0f;
            int n = l_delta = l_overlay - (float)((int)l_overlay) > 0.0f ? Math.round(l_overlay + 0.5f) : (int)l_overlay;
            if (l_delta > 0) {
                l_x += (double)l_delta;
                l_y += (double)l_delta;
                l_width -= (double)(l_delta * 2);
                l_height -= (double)(l_delta * 2);
            }
        }
        return new Rectangle2D.Double(l_x, l_y, l_width, l_height);
    }

    public static Rectangle createStrokeAwareRectangle(Dimension size, Insets insets, float strokeWidth) {
        int l_delta;
        Rectangle l_rect = new Rectangle();
        double l_x = insets.left;
        double l_y = insets.top;
        double l_width = size.width - (insets.left + insets.right);
        double l_height = size.height - (insets.top + insets.bottom);
        float l_overlay = (strokeWidth - 1.0f) / 2.0f;
        int n = l_delta = l_overlay - (float)((int)l_overlay) > 0.0f ? Math.round(l_overlay + 0.5f) : (int)l_overlay;
        if (l_delta > 0) {
            l_x += (double)l_delta;
            l_y += (double)l_delta;
            l_width -= (double)(l_delta * 2);
            l_height -= (double)(l_delta * 2);
        }
        l_rect.setFrame(l_x, l_y, l_width, l_height);
        return l_rect;
    }

    public static Rectangle createStrokeAwareRectangle(Rectangle2D bounds, Stroke stroke) {
        Rectangle l_rect = new Rectangle();
        l_rect.setFrame(StrokeAware.createStrokeAwareRectangle2D(bounds, stroke));
        return l_rect;
    }

    public static int getStrokeOverlay(float strokeWidth) {
        float l_overlay = (strokeWidth - 1.0f) / 2.0f;
        return l_overlay - (float)((int)l_overlay) > 0.0f ? Math.round(l_overlay + 0.5f) : (int)l_overlay;
    }

    public static Rectangle createOverlayRectangle(Rectangle bounds, float strokeWidth) {
        int l_overlay = StrokeAware.getStrokeOverlay(strokeWidth);
        return new Rectangle(bounds.x - l_overlay, bounds.y - l_overlay, bounds.width + l_overlay * 2, bounds.height + l_overlay * 2);
    }
}

