/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.shapes;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public class Grid {
    private static final Insets NO_INSETS = new Insets(0, 0, 0, 0);
    protected final int rows;
    protected final int columns;
    protected final Rectangle[] cellBounds;
    private Insets cellInsets;
    private int width;
    private int height;
    private Insets border;
    private Dimension cellPreferredSize;
    private Dimension cellSize;
    private float outlineStrokeWidth;

    public Grid(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        this.cellBounds = new Rectangle[this.rows * this.columns];
        this.cellInsets = NO_INSETS;
        this.border = NO_INSETS;
        this.cellPreferredSize = null;
        this.height = 0;
        this.width = 0;
        this.outlineStrokeWidth = 1.0f;
        this.cellSize = null;
    }

    public void setCellInsets(Insets insets) {
        this.cellInsets = (Insets)insets.clone();
    }

    public void setOutlineStrokeWidth(float strokeWidth) {
        this.outlineStrokeWidth = strokeWidth;
        this.layout();
    }

    public int getCellCount() {
        return this.rows * this.columns;
    }

    public void setInsets(Insets insets) {
        this.border = (Insets)insets.clone();
        this.layout();
    }

    public void setCellPreferredSize(int width, int height) {
        this.cellPreferredSize = new Dimension(width, height);
    }

    public Dimension getPreferredSize() {
        Insets l_insets = this.estimateGridInsets();
        int l_width = this.cellPreferredSize.width * this.columns + (this.cellInsets.left + this.cellInsets.right) * (this.columns - 1) + l_insets.left + l_insets.right;
        int l_height = this.cellPreferredSize.height * this.rows + (this.cellInsets.top + this.cellInsets.bottom) * (this.rows - 1) + l_insets.top + l_insets.bottom;
        return new Dimension(l_width, l_height);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.layout();
    }

    protected final int getStrokeOverlay() {
        return Grid.getStrokeOverlay(this.outlineStrokeWidth);
    }

    public Dimension getCellSize() {
        return this.cellSize;
    }

    protected Insets estimateGridInsets() {
        int l_overlay = this.getStrokeOverlay();
        Insets l_insets = new Insets(this.border.top + (this.cellInsets.top > l_overlay ? this.cellInsets.top : l_overlay), this.border.left + (this.cellInsets.left > l_overlay ? this.cellInsets.left : l_overlay), this.border.bottom + (this.cellInsets.bottom > l_overlay ? this.cellInsets.bottom : l_overlay), this.border.right + (this.cellInsets.right > l_overlay ? this.cellInsets.right : l_overlay));
        return l_insets;
    }

    protected void layout() {
        Insets l_insets = this.estimateGridInsets();
        int l_width = this.width - (l_insets.left + l_insets.right) - (this.cellInsets.left + this.cellInsets.right) * (this.columns - 1);
        int l_height = this.height - (l_insets.top + l_insets.bottom) - (this.cellInsets.top + this.cellInsets.bottom) * (this.rows - 1);
        int l_cellWidth = l_width / this.columns;
        int l_cellHeight = l_height / this.rows;
        this.cellSize = new Dimension(l_cellWidth, l_cellHeight);
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                int l_index = this.indexOf(r, c);
                int l_x = l_insets.left + (this.cellInsets.left + this.cellInsets.right + l_cellWidth) * c;
                int l_y = l_insets.top + (this.cellInsets.top + this.cellInsets.bottom + l_cellHeight) * r;
                this.cellBounds[l_index] = new Rectangle(l_x, l_y, l_cellWidth, l_cellHeight);
            }
        }
    }

    public Rectangle getBounds() {
        Rectangle l_cell0 = this.getCellBounds(0);
        Rectangle l_cellN = this.getCellBounds(this.getCellCount() - 1);
        int l_x = l_cell0.x;
        int l_y = l_cell0.y;
        int l_width = l_cellN.x + l_cellN.width - l_x;
        int l_height = l_cellN.y + l_cellN.height - l_y;
        return new Rectangle(l_x, l_y, l_width, l_height);
    }

    public Rectangle getBoundsOutline() {
        Rectangle l_bounds = this.getBounds();
        int l_overlay = this.getStrokeOverlay();
        return new Rectangle(l_bounds.x - l_overlay, l_bounds.y - l_overlay, l_bounds.width + l_overlay * 2, l_bounds.height + l_overlay * 2);
    }

    public Rectangle getCellBounds(int index) {
        return (Rectangle)this.cellBounds[index].clone();
    }

    public int cellAt(Point pnt) {
        for (int i = 0; i < this.getCellCount(); ++i) {
            if (!this.getCellBounds(i).contains(pnt)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(int row, int column) {
        return row * this.columns + column;
    }

    public static int getStrokeOverlay(float strokeWidth) {
        float l_overlay = (strokeWidth - 1.0f) / 2.0f;
        return l_overlay - (float)((int)l_overlay) > 0.0f ? Math.round(l_overlay + 0.5f) : (int)l_overlay;
    }
}

