/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.model;

import com.valeras.colorwheel_harmony.actions.FileLoadImageAction;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;

public class ImageColorPickerModel {
    public static final String PROPERTY_IMAGE = "color_picker_model.property.image";
    public static final String PROPERTY_SAMPLE_COLORS = "color_picker_model.property.sample_colors";
    private final int DEFAULT_SAMPLES_COUNT = 16;
    private final ArrayList<PropertyChangeListener> listeners;
    private BufferedImage image = null;
    private int samplesCount = 16;
    private Color[] sampleColors = null;
    private final AbstractAction loadImageAction = new FileLoadImageAction();

    public ImageColorPickerModel() {
        this.listeners = new ArrayList();
    }

    public AbstractAction getLoadImageAction() {
        return this.loadImageAction;
    }

    public int getSamplesCount() {
        return this.samplesCount;
    }

    public void setImage(BufferedImage image) {
        BufferedImage l_image = this.image;
        this.image = image;
        this.firePropertyChangeEvent(PROPERTY_IMAGE, l_image, image);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setSampleColors(Color[] colors) {
        Color[] l_colors = this.sampleColors;
        this.sampleColors = Arrays.copyOf(colors, colors.length);
        this.firePropertyChangeEvent(PROPERTY_SAMPLE_COLORS, l_colors, this.sampleColors);
    }

    public Color[] getSampleColors() {
        return this.sampleColors;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.add(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.remove(l);
    }

    protected void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent l_event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (PropertyChangeListener l : this.listeners) {
            l.propertyChange(l_event);
        }
    }
}

