/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.model;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorPickerModel {
    protected static final NumberFormat defaultIntegerFormat = NumberFormat.getIntegerInstance();
    protected final ComponentParams RGB_R = new ComponentParams(0, 255.0, 0.0, 255.0, 1.0, defaultIntegerFormat, "R", null);
    protected final ComponentParams RGB_G = new ComponentParams(1, 255.0, 0.0, 255.0, 1.0, defaultIntegerFormat, "G", null);
    protected final ComponentParams RGB_B = new ComponentParams(2, 255.0, 0.0, 255.0, 1.0, defaultIntegerFormat, "B", null);
    protected final ComponentParams HSB_H = new ComponentParams(0, 360.0, 0.0, 360.0, 1.0, defaultIntegerFormat, "H", "\u00b0");
    protected final ComponentParams HSB_S = new ComponentParams(1, 100.0, 0.0, 100.0, 1.0, defaultIntegerFormat, "S", "%");
    protected final ComponentParams HSB_B = new ComponentParams(2, 100.0, 0.0, 100.0, 1.0, defaultIntegerFormat, "B", "%");
    protected final ComponentParams LAB_L = new ComponentParams(0, 1.0, 0.0, 100.0, 1.0, defaultIntegerFormat, "L", null);
    protected final ComponentParams LAB_a = new ComponentParams(1, 1.0, -128.0, 127.0, 1.0, defaultIntegerFormat, "a", null);
    protected final ComponentParams LAB_b = new ComponentParams(2, 1.0, -128.0, 127.0, 1.0, defaultIntegerFormat, "b", null);
    protected final ComponentParams CMYK_C = new ComponentParams(0, 100.0, 0.0, 100.0, 1.0, defaultIntegerFormat, "C", "%");
    protected final ComponentParams CMYK_M = new ComponentParams(1, 100.0, 0.0, 100.0, 1.0, defaultIntegerFormat, "M", "%");
    protected final ComponentParams CMYK_Y = new ComponentParams(2, 100.0, 0.0, 100.0, 1.0, defaultIntegerFormat, "Y", "%");
    protected final ComponentParams CMYK_K = new ComponentParams(3, 100.0, 0.0, 100.0, 1.0, defaultIntegerFormat, "K", "%");
    protected final ColorSpace csCIEXYZ;
    protected final ColorSpace csRGB;
    protected final ColorSpace csLab;
    protected final ColorSpace csCMYK;
    protected final RGBColorModel rgbModel;
    protected final ColorModel hsbModel;
    protected final ColorModel labModel;
    protected final ColorModel cmykModel;
    private float[] colorvalue;
    protected final ArrayList<ChangeListener> changeListeners;
    protected final ChangeEvent defaultChangeEvent;
    private final String cmykProfile;

    public ColorPickerModel(ColorSpace lab, ColorSpace cmyk, String profile) {
        ComponentParams[] l_rgb = new ComponentParams[]{this.RGB_R, this.RGB_G, this.RGB_B};
        ComponentParams[] l_hsb = new ComponentParams[]{this.HSB_H, this.HSB_S, this.HSB_B};
        ComponentParams[] l_lab = new ComponentParams[]{this.LAB_L, this.LAB_a, this.LAB_b};
        ComponentParams[] l_cmyk = new ComponentParams[]{this.CMYK_C, this.CMYK_M, this.CMYK_Y, this.CMYK_K};
        this.csCIEXYZ = ColorSpace.getInstance(1001);
        this.csRGB = ColorSpace.getInstance(1000);
        this.colorvalue = new float[3];
        this.changeListeners = new ArrayList();
        this.defaultChangeEvent = new ChangeEvent(this);
        this.csLab = lab;
        this.csCMYK = cmyk;
        this.cmykProfile = profile;
        this.rgbModel = new RGBColorModel(5, this.csRGB, "RGB", l_rgb);
        this.hsbModel = new HSBColorModel(7, this.csRGB, "HSB", l_hsb);
        this.labModel = lab != null ? new ColorModel(1, this.csLab, "Lab", l_lab) : null;
        this.cmykModel = cmyk != null ? new CMYKColorModel(9, this.csCMYK, "CMYK", l_cmyk) : null;
    }

    public boolean isLabSupported() {
        return this.labModel != null;
    }

    public boolean isCMYKSupported() {
        return this.cmykModel != null;
    }

    public String getCMYKProfileName() {
        return this.cmykProfile;
    }

    public void setColor(Color color) {
        float[] l_colorvalue = color.getColorSpace().toCIEXYZ(color.getColorComponents(null));
        this.updateColor(l_colorvalue, null);
    }

    public Color getColor() {
        Color l_color;
        try {
            l_color = new Color(this.csCIEXYZ, this.colorvalue, 1.0f);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(ColorPickerModel.class.getName()).log(Level.WARNING, null, ex);
            return null;
        }
        return l_color;
    }

    public void setRGB(int value) {
        this.rgbModel.setRGB(value);
    }

    public int getRGB() {
        return this.rgbModel.getRGB();
    }

    protected void updateColor(float[] ciexyz, ColorModel originator) {
        this.colorvalue = Arrays.copyOf(ciexyz, ciexyz.length);
        for (int i = 0; i < this.colorvalue.length; ++i) {
            float l_value = this.colorvalue[i];
            if (!(l_value < 0.0f)) continue;
            this.colorvalue[i] = Math.abs(l_value);
        }
        if (this.rgbModel != originator) {
            this.rgbModel.setColorValue(this.colorvalue);
        }
        if (this.hsbModel != originator) {
            this.hsbModel.setColorValue(this.colorvalue);
        }
        if (this.labModel != null && originator != this.labModel) {
            this.labModel.setColorValue(this.colorvalue);
        }
        if (this.cmykModel != null && originator != this.cmykModel) {
            this.cmykModel.setColorValue(this.colorvalue);
        }
        this.fireChangeEvent(this.defaultChangeEvent);
    }

    public ColorModel getModel(int type) {
        ColorModel l_model;
        switch (type) {
            case 5: {
                l_model = this.rgbModel;
                break;
            }
            case 7: {
                l_model = this.hsbModel;
                break;
            }
            case 1: {
                l_model = this.labModel;
                break;
            }
            case 9: {
                l_model = this.cmykModel;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal color model type: " + type);
            }
        }
        return l_model;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    protected void fireChangeEvent(ChangeEvent e) {
        for (ChangeListener l : this.changeListeners) {
            l.stateChanged(e);
        }
    }

    static {
        defaultIntegerFormat.setRoundingMode(RoundingMode.HALF_UP);
        defaultIntegerFormat.setMaximumIntegerDigits(3);
    }

    public class ComponentParams {
        private final int index;
        private final double scale;
        private final double min;
        private final double max;
        private final double step;
        private final NumberFormat format;
        private final String label;
        private final String measure;

        public ComponentParams(int index, double scale, double min, double max, double step, NumberFormat format, String label, String measure) {
            this.index = index;
            this.scale = scale;
            this.min = min;
            this.max = max;
            this.step = step;
            this.format = format;
            this.label = label;
            this.measure = measure;
        }

        public final int getIndex() {
            return this.index;
        }

        public final String getLabel() {
            return this.label;
        }

        public final String getMeasure() {
            return this.measure;
        }

        public final double getScale() {
            return this.scale;
        }

        public final double getMinValue() {
            return this.min;
        }

        public final double getMaxValue() {
            return this.max;
        }

        public final double getStep() {
            return this.step;
        }

        public NumberFormat getFormat() {
            return this.format;
        }
    }

    protected class CMYKColorModel
    extends ColorModel {
        private static final float REF_X = 1.0145203f;
        private static final float REF_Y = 1.0f;
        private static final float REF_Z = 0.7578068f;
        private static final float REF_Z2 = 0.8249f;

        public CMYKColorModel(int type, ColorSpace cs, String name, ComponentParams[] components) {
            super(type, cs, name, components);
        }

        @Override
        public void setColorValue(float[] ciexyz) {
            float[] l_values = new float[]{ciexyz[0] / 1.0145203f, ciexyz[1], ciexyz[2] / 0.7578068f};
            this.components = this.cs.fromCIEXYZ(ciexyz);
        }

        @Override
        public float[] getColorValue() {
            return this.cs.toCIEXYZ(this.components);
        }
    }

    protected class HSBColorModel
    extends ColorModel {
        public HSBColorModel(int type, ColorSpace cs, String name, ComponentParams[] components) {
            super(type, cs, name, components);
        }

        @Override
        public void setColorValue(float[] ciexyz) {
            float[] l_components = this.cs.fromCIEXYZ(ciexyz);
            Color l_color = new Color(l_components[0], l_components[1], l_components[2]);
            this.components = Color.RGBtoHSB(l_color.getRed(), l_color.getGreen(), l_color.getBlue(), null);
        }

        @Override
        public float[] getColorValue() {
            Color l_color = Color.getHSBColor(this.components[0], this.components[1], this.components[2]);
            return this.cs.toCIEXYZ(l_color.getColorComponents(null));
        }
    }

    protected class RGBColorModel
    extends ColorModel {
        private int value;

        public RGBColorModel(int type, ColorSpace cs, String name, ComponentParams[] components) {
            super(type, cs, name, components);
            this.value = 0;
        }

        public void setRGB(int value) {
            this.value = value;
            this.components = new Color(value).getColorComponents(null);
            ColorPickerModel.this.updateColor(this.getColorValue(), this);
        }

        public int getRGB() {
            return this.value;
        }

        @Override
        public void setColorValue(float[] ciexyz) {
            super.setColorValue(ciexyz);
            this.value = new Color(this.components[0], this.components[1], this.components[2]).getRGB();
        }

        @Override
        public String getComponentAsText(int index) {
            int l_value = this.value >> (2 - index) * 8 & 0xFF;
            String l_text = Integer.toString(l_value).trim();
            return l_text;
        }

        @Override
        public void setComponentAsText(int index, String text) {
            int l_value;
            int[] l_values = new int[3];
            for (int i = 0; i < 3; ++i) {
                l_values[i] = this.value >> (2 - i) * 8 & 0xFF;
            }
            try {
                l_value = Integer.parseInt(text);
            }
            catch (NumberFormatException ex) {
                return;
            }
            l_values[index] = l_value;
            l_value = (l_values[0] & 0xFF) << 16 | (l_values[1] & 0xFF) << 8 | l_values[2] & 0xFF;
            this.setRGB(l_value);
        }
    }

    public class ColorModel {
        protected final int type;
        private final String name;
        protected final ColorSpace cs;
        private final ComponentParams[] params;
        protected float[] components;

        public ColorModel(int type, ColorSpace cs, String name, ComponentParams[] params) {
            this.type = type;
            this.name = name;
            this.cs = cs;
            if (params.length != cs.getNumComponents()) {
                throw new IllegalArgumentException("Wrong number of components: " + name);
            }
            this.params = Arrays.copyOf(params, params.length);
        }

        public void setColorValue(float[] ciexyz) {
            this.components = this.cs.fromCIEXYZ(ciexyz);
        }

        public float[] getColorValue() {
            return this.cs.toCIEXYZ(this.components);
        }

        public int getType() {
            return this.type;
        }

        public int getNumComponents() {
            return this.params.length;
        }

        public String getName() {
            return this.name;
        }

        public void setComponentAsText(int index, String text) {
            ComponentParams l_cd = this.params[index];
            if (text.trim().equals("-")) {
                return;
            }
            try {
                double l_value = l_cd.getFormat().parse(text).doubleValue();
            }
            catch (ParseException ex) {
                Logger.getLogger(ColorPickerModel.class.getName()).log(Level.WARNING, null, ex);
                return;
            }
            this.components[index] = (float)(l_value /= l_cd.getScale());
            ColorPickerModel.this.updateColor(this.getColorValue(), this);
        }

        public String getComponentAsText(int index) {
            ComponentParams l_cd = this.params[index];
            int l_value = (int)Math.round((double)this.components[index] * l_cd.getScale());
            return l_cd.getFormat().format(l_value);
        }

        public ComponentParams getComponentParams(int index) {
            return this.params[index];
        }
    }
}

