/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.model;

import com.valeras.color_combine.cms.ColorMatchingSystem;
import com.valeras.colorimetry.CIE_ColourDifference;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorMatchingModel {
    private ColorMatchingSystem cms;
    protected final ArrayList<ChangeListener> changeListeners;
    protected final ChangeEvent defaultChangeEvent;
    private final CIE_ColourDifference formula;

    public ColorMatchingModel(ColorMatchingSystem cms, CIE_ColourDifference formula) {
        this.cms = cms;
        this.formula = formula;
        this.changeListeners = new ArrayList();
        this.defaultChangeEvent = new ChangeEvent(this);
        cms.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorMatchingModel.this.fireChangeEvent(ColorMatchingModel.this.defaultChangeEvent);
            }
        });
    }

    public ColorMatchingSystem getCMS() {
        return this.cms;
    }

    public float getColorDifference() {
        Color l_reference = this.cms.getReferenceColor();
        Color l_sample = this.cms.getSampleColor();
        return l_reference != null && l_sample != null ? this.formula.delta(l_reference, l_sample) : 0.0f;
    }

    public Color getColor() {
        return this.cms.getSampleColor();
    }

    public Color getOriginalColor() {
        return this.cms.getReferenceColor();
    }

    public boolean isApproved() {
        return this.cms.isApproved();
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    protected void fireChangeEvent(ChangeEvent e) {
        for (ChangeListener l : this.changeListeners) {
            l.stateChanged(e);
        }
    }
}

