/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui;

import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.ui.swing.AbstractColorSourceIconFactory;
import java.awt.FlowLayout;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class ColorSourceSelectionPanel
extends JPanel {
    private final ButtonGroup buttonGroup;
    private static final String STR_COLOR_WHEEL = "color_source.color_wheel.name";

    public ColorSourceSelectionPanel() {
        this.setLayout(new FlowLayout(0));
        this.buttonGroup = new ButtonGroup();
        this.addColorSourceButton(null, 1, StringTable.get(STR_COLOR_WHEEL));
    }

    public final void addColorSourceButton(AbstractAction action, int mode, String name) {
        AbstractButton l_button = this.createColorSourceButton(action, mode, name);
        this.buttonGroup.add(l_button);
        this.add(l_button);
    }

    protected AbstractButton createColorSourceButton(AbstractAction action, int mode, String name) {
        JToggleButton l_button = new JToggleButton();
        Icon l_icon = AbstractColorSourceIconFactory.getInstance().createIcon(mode, false);
        l_button.setIcon(l_icon);
        l_icon = AbstractColorSourceIconFactory.getInstance().createIcon(mode, true);
        l_button.setSelectedIcon(l_icon);
        l_button.setText(null);
        l_button.setToolTipText(name);
        l_button.setFocusPainted(false);
        return l_button;
    }

    public void setSelectedButton(String command) {
        Enumeration<AbstractButton> l_buttons = this.buttonGroup.getElements();
        while (l_buttons.hasMoreElements()) {
            AbstractButton l_button = l_buttons.nextElement();
            String l_name = l_button.getActionCommand();
            if (!l_name.equals(command)) continue;
            l_button.setSelected(true);
            break;
        }
    }
}

