/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui;

import com.valeras.color_combine.model.ColorScheme;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.ui.swing.AbstractColorSchemeIconFactory;
import java.awt.FlowLayout;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class ColorSchemeSelectionPanel
extends JPanel {
    private final ButtonGroup buttonGroup;

    public ColorSchemeSelectionPanel() {
        this.setLayout(new FlowLayout());
        this.setOpaque(false);
        this.buttonGroup = new ButtonGroup();
    }

    public void addColorSchemeButton(AbstractAction action, ColorScheme colorScheme) {
        AbstractButton l_button = this.createColorSchemeButton(action, colorScheme);
        this.buttonGroup.add(l_button);
        this.add(l_button);
    }

    protected AbstractButton createColorSchemeButton(AbstractAction action, ColorScheme colorScheme) {
        JToggleButton l_button = new JToggleButton(action);
        Icon l_icon = AbstractColorSchemeIconFactory.getInstance().createIcon(colorScheme, false);
        l_button.setIcon(l_icon);
        l_icon = AbstractColorSchemeIconFactory.getInstance().createIcon(colorScheme, true);
        l_button.setSelectedIcon(l_icon);
        l_button.setText(null);
        l_button.setToolTipText(StringTable.get(colorScheme.getName()));
        l_button.setFocusPainted(false);
        return l_button;
    }

    public void setSelectedButton(String command) {
        Enumeration<AbstractButton> l_buttons = this.buttonGroup.getElements();
        while (l_buttons.hasMoreElements()) {
            AbstractButton l_button = l_buttons.nextElement();
            String l_name = l_button.getActionCommand();
            if (!l_name.equals(command)) continue;
            l_button.setSelected(true);
            break;
        }
    }
}

