/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui;

import com.valeras.colorwheel_harmony.actions.EditAddBlueFlavorAction;
import com.valeras.colorwheel_harmony.actions.EditAddGreenFlavorAction;
import com.valeras.colorwheel_harmony.actions.EditAddRedFlavorAction;
import com.valeras.colorwheel_harmony.actions.EditAddYellowFlavorAction;
import com.valeras.colorwheel_harmony.actions.EditColorComponentsAction;
import com.valeras.colorwheel_harmony.actions.ToolsMatchColorChartPopupAction;
import com.valeras.colorwheel_harmony.actions.ViewCycleColorToolAction;
import com.valeras.colorwheel_harmony.actions.ViewCyclePaletteLayoutAction;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.model.ColorCombineToolkit;
import com.valeras.colorwheel_harmony.ui.ColorSchemeSelectionPanel;
import com.valeras.colorwheel_harmony.ui.ColorTool;
import com.valeras.colorwheel_harmony.ui.ColorToolbarPanel;
import com.valeras.colorwheel_harmony.ui.swing.AbstractColorWheelSkinFactory;
import com.valeras.colorwheel_harmony.ui.swing.AbstractComponentBorderFactory;
import com.valeras.colorwheel_harmony.ui.swing.AbstractDropShadowBorderFactory;
import com.valeras.colorwheel_harmony.ui.swing.components.JxColorMatching;
import com.valeras.colorwheel_harmony.ui.swing.components.JxColorPalette;
import com.valeras.colorwheel_harmony.ui.swing.components.JxColorWheel;
import com.valeras.colorwheel_harmony.ui.swing.components.JxContrastPattern;
import com.valeras.colorwheel_harmony.ui.swing.components.JxGrayscaleColorTuner;
import com.valeras.colorwheel_harmony.ui.swing.components.JxHotSpotButton;
import com.valeras.colorwheel_harmony.ui.swing.components.JxImageColorPicker;
import com.valeras.colorwheel_harmony.ui.swing.components.JxVariateColorTuner;
import com.valeras.colorwheel_harmony.ui.swing.icons.paint_buttons.PaintButtonDn;
import com.valeras.colorwheel_harmony.ui.swing.icons.paint_buttons.PaintButtonLR;
import com.valeras.colorwheel_harmony.ui.swing.icons.paint_buttons.PaintButtonRGBY;
import com.valeras.colorwheel_harmony.ui.swing.model.PaintButtonModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class ColorCombinePanel
extends JPanel {
    private static final String STR_MODE_TITLE = "component.title.color_source";
    private static final String STR_COLORWHEEL_TITLE = "component.title.color_wheel";
    private static final String STR_COLORWHEEL_MENU_TOOLTIP = "component.color_wheel.menu.tooltip";
    private static final String STR_MATCHTUNER_TITLE = "component.title.match_tuner";
    private static final String STR_MATCHTUNER_MENU_TOOLTIP = "component.match_tuner.menu.tooltip";
    private static final String STR_VARIATETUNER_TITLE = "component.title.variate_tuner";
    private static final String STR_COLORPALETTE_TITLE = "component.title.color_palette";
    private static final String STR_COLORPALETTE_MENU_TOOLTIP = "component.color_palette.menu.tooltip";
    private static final String STR_COLORTUNER_MENU_TOOLTIP = "component.color_tuner.menu.tooltip";
    private static final String STR_GRAYSCALE_TITLE = "component.title.grayscale";
    private static final String STR_COLORSCHEME_TITLE = "component.title.color_scheme";
    private static final String STR_BACK_BUTTON = "view.home_button";
    private static final String MSG_WRONG_TOOL = "There is no component registered for: {0}";
    final Insets insets = new Insets(5, 2, 1, 2);
    private ColorCombineToolkit toolkit;
    private final ComponentPanel panelColorTool;
    private final ComponentPanel panelColorPalette;
    private final ComponentPanel panelVariateColor;
    private final ComponentPanel panelMatchColor;
    private final ComponentPanel panelGrayscale;
    private Dimension colorToolSize;
    private ColorTool selectedColorTool;
    private final HashMap<String, JComponent> modeComponents;
    private final HashMap<String, JComponent> modeControls;
    public final JxColorPalette colorPalette;
    public final JxColorMatching colorMatching;
    public final JxVariateColorTuner variateTuner;
    public final JxGrayscaleColorTuner grayscaleTuner;
    public final JxColorWheel colorWheel;
    private final JxContrastPattern contrastPattern;
    public final JxImageColorPicker colorPicker;
    final ColorSchemeSelectionPanel colorSchemePanel;
    final ColorToolbarPanel contrastToolbar;
    final ColorToolbarPanel imageToolbar;

    public ColorCombinePanel() {
        JButton l_button = new JButton("Dummy");
        int l_extent = l_button.getPreferredSize().height < 32 ? 16 : 24;
        Dimension l_paintButtonSize = new Dimension(l_extent, l_extent);
        this.setOpaque(true);
        this.setLayout(new GridBagLayout());
        this.toolkit = null;
        this.modeComponents = new HashMap();
        this.modeControls = new HashMap();
        PaintButtonModel l_pickerIcons = this.createColorPickerPaintButtonModel(l_paintButtonSize);
        this.panelColorTool = this.createComponentPanel(StringTable.get(STR_COLORWHEEL_TITLE), null, l_pickerIcons);
        this.colorToolSize = null;
        this.colorWheel = new JxColorWheel(AbstractColorWheelSkinFactory.createDefaultColorWheelSkin(), AbstractDropShadowBorderFactory.getInstance().getDropTranslate(), AbstractDropShadowBorderFactory.getInstance().getOpacity());
        this.colorSchemePanel = new ColorSchemeSelectionPanel();
        this.contrastPattern = new JxContrastPattern();
        this.contrastPattern.setBorder(AbstractDropShadowBorderFactory.createDropShadowBorder());
        this.contrastToolbar = this.createColorToolbar();
        this.contrastPattern.putToolbarActions(this.contrastToolbar);
        this.colorPicker = new JxImageColorPicker();
        this.colorPicker.setBorder(AbstractDropShadowBorderFactory.createDropShadowBorder());
        this.imageToolbar = this.createColorToolbar();
        this.colorPicker.putToolbarActions(this.imageToolbar);
        this.colorMatching = new JxColorMatching();
        this.colorMatching.setBorder(AbstractDropShadowBorderFactory.createDropShadowBorder());
        PaintButtonModel l_matchIcons = this.createColorMatchingPaintButtonModel(l_paintButtonSize);
        this.panelMatchColor = this.createComponentPanel(StringTable.get(STR_MATCHTUNER_TITLE), this.colorMatching, l_matchIcons);
        this.grayscaleTuner = new JxGrayscaleColorTuner();
        this.grayscaleTuner.setBorder(AbstractDropShadowBorderFactory.createDropShadowBorder());
        this.panelGrayscale = this.createComponentPanel(StringTable.get(STR_GRAYSCALE_TITLE), this.grayscaleTuner, null);
        this.colorPalette = new JxColorPalette(null);
        PaintButtonModel l_paletteIcons = this.createColorPalettePaintButtonModel(l_paintButtonSize);
        this.panelColorPalette = this.createComponentPanel(StringTable.get(STR_COLORPALETTE_TITLE), this.colorPalette, l_paletteIcons);
        this.variateTuner = new JxVariateColorTuner(3, 3, new EditColorComponentsAction());
        this.variateTuner.setBorder(AbstractDropShadowBorderFactory.createDropShadowBorder());
        PaintButtonModel l_tunerIcons = this.createColorTunerPaintButtonModel(new Dimension(l_paintButtonSize.width * 5 / 2, l_paintButtonSize.height));
        this.panelVariateColor = this.createComponentPanel(StringTable.get(STR_VARIATETUNER_TITLE), this.variateTuner, l_tunerIcons);
        this.selectedColorTool = this.colorWheel;
        this.panelColorTool.setComponent(this.colorWheel);
        this.panelColorTool.setComponentControls(this.colorSchemePanel);
        this.modeComponents.put("mode.color_wheel", this.colorWheel);
        this.modeComponents.put("mode.contrast_pattern", this.contrastPattern);
        this.modeComponents.put("mode.color_picker", this.colorPicker);
        this.modeControls.put("mode.color_wheel", this.colorSchemePanel);
        this.modeControls.put("mode.contrast_pattern", this.contrastToolbar);
        this.modeControls.put("mode.color_picker", this.imageToolbar);
        this.add((Component)this.panelColorTool, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 17, 1, this.insets, 0, 0));
        this.add((Component)this.panelColorPalette, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 1, this.insets, 0, 0));
        this.add((Component)this.panelVariateColor, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, this.insets, 0, 0));
        this.add((Component)this.panelMatchColor, new GridBagConstraints(2, 1, 1, 2, 0.0, 0.0, 17, 1, this.insets, 0, 0));
        this.add((Component)this.panelGrayscale, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, this.insets, 0, 0));
    }

    private ComponentPanel createComponentPanel(String title, JComponent component, PaintButtonModel model) {
        JxHotSpotButton l_button;
        JxHotSpotButton jxHotSpotButton = l_button = model != null ? new JxHotSpotButton(model) : null;
        if (l_button != null) {
            l_button.setToolTipText(model.getTooltip());
        }
        ComponentPanel l_panel = new ComponentPanel(title, component, l_button);
        return l_panel;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.panelColorTool != null) {
            this.panelColorTool.setBackground(bg);
            this.panelColorPalette.setBackground(bg);
            this.panelVariateColor.setBackground(bg);
            this.panelMatchColor.setBackground(bg);
            this.panelGrayscale.setBackground(bg);
        }
    }

    public void setColorCombineToolkit(ColorCombineToolkit toolkit) {
        this.toolkit = toolkit;
    }

    public String getSelectedColorTool() {
        if (this.selectedColorTool == null) {
            return null;
        }
        Set<Map.Entry<String, JComponent>> l_toolset = this.modeComponents.entrySet();
        for (Map.Entry<String, JComponent> me : l_toolset) {
            if (!me.getValue().equals(this.selectedColorTool)) continue;
            return me.getKey();
        }
        return null;
    }

    public final void selectColorTool(String tool) {
        JComponent l_component = this.modeComponents.get(tool);
        JComponent l_control = this.modeControls.get(tool);
        if (l_component == null || l_control == null) {
            throw new IllegalArgumentException(MessageFormat.format(MSG_WRONG_TOOL, tool));
        }
        if (this.selectedColorTool != null) {
            this.selectedColorTool.deactivateTool();
        }
        if (this.colorToolSize == null) {
            this.colorToolSize = this.colorWheel.getSize();
        }
        if (l_component != this.colorWheel) {
            l_component.setPreferredSize(this.colorToolSize);
        }
        this.panelColorTool.setTitle(StringTable.get(tool));
        this.panelColorTool.setComponent(l_component);
        this.panelColorTool.setComponentControls(l_control);
        this.selectedColorTool = (ColorTool)((Object)l_component);
        this.selectedColorTool.activateTool(this.toolkit);
        this.panelColorTool.validate();
        this.panelColorTool.repaint();
    }

    private ColorToolbarPanel createColorToolbar() {
        ColorToolbarPanel l_toolbar = new ColorToolbarPanel();
        BackButtonAction l_action = new BackButtonAction(StringTable.get(STR_BACK_BUTTON));
        l_toolbar.add(l_action);
        return l_toolbar;
    }

    private PaintButtonModel createColorPickerPaintButtonModel(Dimension size) {
        AbstractAction[] l_actions = new AbstractAction[]{new ViewCycleColorToolAction(-1), new ViewCycleColorToolAction(1)};
        PaintButtonModel l_model = new PaintButtonModel(new PaintButtonLR(size.width, size.height, Color.black), StringTable.get(STR_COLORWHEEL_MENU_TOOLTIP), l_actions);
        return l_model;
    }

    private PaintButtonModel createColorPalettePaintButtonModel(Dimension size) {
        AbstractAction[] l_actions = new AbstractAction[]{new ViewCyclePaletteLayoutAction(-1), new ViewCyclePaletteLayoutAction(1)};
        PaintButtonModel l_model = new PaintButtonModel(new PaintButtonLR(size.width, size.height, Color.black), StringTable.get(STR_COLORPALETTE_MENU_TOOLTIP), l_actions);
        return l_model;
    }

    private PaintButtonModel createColorTunerPaintButtonModel(Dimension size) {
        AbstractAction[] l_actions = new AbstractAction[]{new EditAddRedFlavorAction(), new EditAddGreenFlavorAction(), new EditAddBlueFlavorAction(), new EditAddYellowFlavorAction()};
        PaintButtonModel l_model = new PaintButtonModel(new PaintButtonRGBY(size.width, size.height, Color.black, 0.45f), StringTable.get(STR_COLORTUNER_MENU_TOOLTIP), l_actions);
        return l_model;
    }

    private PaintButtonModel createColorMatchingPaintButtonModel(Dimension size) {
        AbstractAction[] l_actions = new AbstractAction[]{new ToolsMatchColorChartPopupAction(this.colorMatching)};
        PaintButtonModel l_model = new PaintButtonModel(new PaintButtonDn(size.width, size.height, Color.black), StringTable.get(STR_MATCHTUNER_MENU_TOOLTIP), l_actions);
        return l_model;
    }

    private class BackButtonAction
    extends AbstractAction {
        public BackButtonAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorCombinePanel.this.selectColorTool("mode.color_wheel");
        }
    }

    private class ComponentPanel
    extends JPanel {
        private final JLabel caption;
        private final JPanel titlePanel;
        private final JPanel componentPanel;
        private JComponent component;
        private JComponent controls;

        public ComponentPanel(String title, JComponent component, JComponent icons) {
            int l_arc = 6;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.component = component;
            this.controls = null;
            Border l_border = AbstractComponentBorderFactory.createPanelBorder(null);
            this.titlePanel = new JPanel();
            this.titlePanel.setLayout(new BoxLayout(this.titlePanel, 0));
            this.titlePanel.setOpaque(false);
            this.titlePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
            this.componentPanel = new JPanel(new BorderLayout());
            this.componentPanel.setBorder(l_border);
            this.componentPanel.setOpaque(false);
            this.caption = new JLabel(title);
            this.titlePanel.add(Box.createHorizontalStrut(6));
            this.titlePanel.add(this.caption);
            this.titlePanel.add(Box.createHorizontalGlue());
            if (icons != null) {
                this.titlePanel.add(icons);
            }
            this.titlePanel.add(Box.createHorizontalStrut(12));
            if (component != null) {
                this.componentPanel.add((Component)component, "Center");
            }
            this.add((Component)this.titlePanel, "North");
            this.add((Component)this.componentPanel, "Center");
        }

        public void setComponent(JComponent component) {
            if (this.component != null) {
                this.componentPanel.remove(this.component);
            }
            this.component = component;
            if (component != null) {
                this.componentPanel.add((Component)component, "Center");
            }
            this.componentPanel.invalidate();
        }

        public void setComponentControls(JComponent controls) {
            if (this.controls != null) {
                this.componentPanel.remove(this.controls);
            }
            this.controls = controls;
            if (controls != null) {
                this.componentPanel.add((Component)controls, "South");
            }
            this.componentPanel.invalidate();
        }

        @Override
        public void setBackground(Color bg) {
            super.setBackground(bg);
            if (this.titlePanel != null) {
                this.titlePanel.setBackground(bg);
                this.componentPanel.setBackground(bg);
            }
        }

        public void setTitle(String text) {
            this.caption.setText(text);
        }
    }
}

